#
# Copyright (C) 1998 by USC/ISI
# All rights reserved.                                            
#                                                                
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation, advertising
# materials, and other materials related to such distribution and use
# acknowledge that the software was developed by the University of
# Southern California, Information Sciences Institute.  The name of the
# University may not be used to endorse or promote products derived from
# this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# $Header: /usr/src/mash/repository/vint/nam-1/tcl/monitor.tcl,v 1.2 1998/07/06 21:09:28 haoboy Exp $ 

set montab(l) graph
set montab(n) ""
set montab(p) monitor
set montab(d) monitor
set montab(r) monitor
set montab(a) monitor

Animator instproc graph_info { netView x y } {
    $self instvar running resume tracefile
    $self tkvar nowDisp
    catch {destroy $netView.f}
    frame $netView.f -relief groove -borderwidth 2
    set name [$netView getname $nowDisp $x $y]
    set type [lindex $name 0]
    switch $type {
	"l" {
	    set e1 [lindex $name 1]
	    set e2 [lindex $name 2]
	    frame $netView.f.f1 -borderwidth 2 -relief groove
	    pack $netView.f.f1 -side left
	    label $netView.f.f1.l -text "Graph bandwidth" -font [smallfont]
	    pack $netView.f.f1.l -side top
	    frame $netView.f.f1.f -borderwidth 0
	    pack $netView.f.f1.f -side top
	    button $netView.f.f1.f.b2 -relief raised -highlightthickness 0 \
		    -text "Link $e1->$e2" -font [smallfont]\
		    -command "$self end_info $netView;\
		      $self viewgraph \"l $e1 $e2\" bw $tracefile"
	    pack $netView.f.f1.f.b2 -side left -fill x -expand true
	    button $netView.f.f1.f.b3 -relief raised -highlightthickness 0 \
		    -text "Link $e2->$e1" -font [smallfont] \
		    -command "$self end_info $netView;\
		      $self viewgraph \"l $e2 $e1\" bw $tracefile"
	    pack $netView.f.f1.f.b3 -side left -fill x -expand true

	    frame $netView.f.f2 -borderwidth 2 -relief groove
	    pack $netView.f.f2 -side left
	    label $netView.f.f2.l -text "Graph loss" -font [smallfont]
	    pack $netView.f.f2.l -side top
	    frame $netView.f.f2.f -borderwidth 0
	    pack $netView.f.f2.f -side top
	    button $netView.f.f2.f.b2 -relief raised -highlightthickness 0 \
		    -text "Link $e1->$e2" -font [smallfont]\
		    -command "$self end_info $netView;\
		      $self viewgraph \"l $e1 $e2\" loss $tracefile"
	    pack $netView.f.f2.f.b2 -side left -fill x -expand true
	    button $netView.f.f2.f.b3 -relief raised -highlightthickness 0 \
		    -text "Link $e2->$e1" -font [smallfont] \
		    -command "$self end_info $netView;\
		      $self viewgraph \"l $e2 $e1\" loss $tracefile"
	    pack $netView.f.f2.f.b3 -side left -fill x -expand true
	}
    }
    button $netView.f.d -relief raised -highlightthickness 0 \
	    -text "Dismiss" -font [smallfont]\
	    -command "$self end_info $netView"
    pack $netView.f.d -side left  -anchor sw

    place_frame $netView $netView.f $x $y
}

Animator instproc start_info { netView x y key_} {
	$self instvar running resume tracefile 
	$self tkvar nowDisp
	global montab

    if {($running)||([winfo exists $netView.f]&&($resume==1))} {
	set resume 1 
    } else {
	set resume 0
    }
    $self stop 1
    set text [string trim [$netView info $nowDisp $x $y] "\n"]
    if { [string length $text] > 0 } {
	set name [$netView getname $nowDisp $x $y]
	set type [lindex $name 0]
	if {$type==""} {
	    puts "got an empty object name returned from object $text!"
	    return
	}

	catch {destroy $netView.f}
	frame $netView.f -relief groove -borderwidth 2
	message $netView.f.msg -width 8c -text $text \
		-font [option get . smallfont Nam]
	pack $netView.f.msg -side top
	frame $netView.f.f
	pack $netView.f.f -side top -fill x -expand true
	if {$montab($type)=="monitor"} {
	    button $netView.f.f.b -relief raised -highlightthickness 0 \
		    -text "Monitor" \
		    -command "$self monitor $netView $nowDisp $x $y; \
		    $self end_info $netView"
	    pack $netView.f.f.b -side left -fill x -expand true
	} elseif {$montab($type)=="graph"} {
	    button $netView.f.f.b2 -relief raised -highlightthickness 0 \
		    -text "Graph" \
		    -command "$self graph_info $netView $x $y"
	    pack $netView.f.f.b2 -side left -fill x -expand true
	}
	button $netView.f.f.d -relief raised -highlightthickness 0 \
		-text "Dismiss" \
		-command "$self end_info $netView"
	pack $netView.f.f.d -side left -fill x -expand true
	place_frame $netView $netView.f $x $y
    } else {
	$self end_info $netView
    }
}

Animator instproc end_info {netView} { 
        $self instvar resume
	catch { destroy $netView.f }
        if $resume "$self play 1"
}


Animator instproc monitor {netView now x y} {
	$self instvar windows 
	$self tkvar showpanel

	set mon [$netView new_monitor $now $x $y]
	set showpanel(monitor) 1
	if {$mon>=0} {
		$self create_monitor $netView $mon $now
	}
}

# Used exclusively by annotation command
Animator instproc monitor_agent {node agent} {
	$self instvar netViews netModel 
	$self tkvar nowDisp showpanel

	set netView [lindex $netViews 0]
	set mon [$netModel new_monitor_agent $node $agent]
	set showpanel(monitor) 1
	if {$mon>=0} {
		$self create_monitor $netView $mon $nowDisp
	}
}

Animator instproc create_monitor {netView mon now} {
    $self instvar windows monitors maxmon
    frame $windows(monitor).f$maxmon -borderwidth 2 -relief groove
    pack $windows(monitor).f$maxmon -side left -fill y
    set monitors($mon) $windows(monitor).f$maxmon
    set w $windows(monitor).f$maxmon
    message $w.l -aspect 300 -text "\[$mon\] [$netView monitor $now $mon]" \
	    -anchor nw -font [option get . smallfont Nam]
    pack $w.l -side top -anchor w -fill both -expand true
#    button $w.b -text "Hide" -borderwidth 1 \
#	    -command "$self delete_monitor $netView $mon"
#    pack $w.b -side top
    bind $w.l <Enter> \
	    "$w.l configure -background [option get . activeBackground Nam]"
    bind $w.l <Leave> \
	    "$w.l configure -background [option get . background Nam]"
    bind $w.l <1> "$self delete_monitor $netView $mon"
    incr maxmon
}

Animator instproc update_monitors {netView now} {
    $self instvar monitors
    foreach mon [array names monitors] {
	set text [$netView monitor $now $mon]
	if {$text==""} {
	    $self delete_monitor $netView $mon
	} else {
	    set text "\[$mon\] $text"
	    if {[$monitors($mon).l configure -text]!=$text} {
		$monitors($mon).l configure -text "$text"
	    }
	}
    }
}

Animator instproc delete_monitor {netView mon} {
    $self instvar monitors
    $netView delete_monitor $mon
    catch {destroy $monitors($mon)}
    unset monitors($mon)
    $self redrawFrame
}
