#include "pnm.h"

int
main(int argc, char *argv[]) {

    FILE* ifP;
    xelval maxval;
    xel* xelrow;
    int rows, cols, format, row;

    pnm_init(&argc, argv);

    if (argc-1 == 0)
        ifP = stdin;
    else if (argc-1 == 1)
        ifP = pm_openr(argv[1]);
    else
        pm_error("There is at most one argument -- the file name.  "
                 "You specified %d", argc-1);

    pnm_readpnminit(ifP, &cols, &rows, &maxval, &format);
    pnm_writepnminit(stdout, cols, rows, maxval, format, 0);

    xelrow = pnm_allocrow(cols);

    for (row = 0; row < rows; ++row) {
        pnm_readpnmrow(ifP, xelrow, cols, maxval, format);
        pnm_writepnmrow(stdout, xelrow, cols, maxval, format, 0);
	}

    pnm_freerow(xelrow);

    pm_close(ifP);
    pm_close(stdout);

    return 0;
}
