%define name jftpgw
%define version 0.12.0
%define release 2
%define prefix /usr

Summary: An FTP proxy/gateway server
Summary(de): Ein FTP Proxy Server
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Network/Proxies
Source: http://www.mcknight.de/%{name}/%{name}-%{version}.tar.gz
URL: http://www.mcknight.de/%name/
Packager: Dr. Peter Bieringer <pbieringer@aerasec.de> with credits to Joachim Wieland <joe@mcknight.de>
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root

%description

jftpgw is a proxy server for the FTP protocol. If it is running on a
machine, you can use a standard FTP client to connect to that machine. You
log in with remoteuser@destination with the password of the user on the
destination FTP server and the FTP session is forwarded from the `real' FTP
server to the jftpgw proxy and from there to your client. You can also
specify the destination port on the login string. jftpgw supports
passive/active FTP, access restrictions (based on source IP, target IP and
the user name), user rewriting and tries to drop its privileges as often as
possible. You can run jftpgw as a normal user as well.


%description -l de

jftpgw ist ein FTP proxy Server, der Verbindungen zwischen einem FTP Server
und einem FTP Client weiterleitet. Der FTP Client verbindet sich zu dem
jftpgw Rechner auf dessen Port und sendet den Usernamen im Format
"user@zielrechner", damit der Proxy sich als "user" auf dem Rechner
"zielrechner" einloggt und auch das Passwort weiterleitet. jftpgw
untersttzt aktive/passives FTP, Zugangsbeschrnkungen (basierend auf
Herkunfts-IP, Ziel-IP und Username), Ersetzung von Usernamen sowie das
Wechseln auf weniger berechtigte Benutzer. jftpgw kann auch von "normalen"
Benutzern ausgefhrt werden.

%changelog
* Thu Dec 14 2000  Dr. Peter Bieringer <pbieringer@aerasec.de>
Some fixes for RedHat 6.2 usage, path inconsistences and packet contents

%prep
%setup

# Patch for RH 6.x compatiblility, by Dr. Peter Bieringer <pbieringer@aerasec.de>
echo "Apply patch on initscript for RedHat 6.x"
getpatch10 () {
cat <<END
--- jftpgw-0.0.11/support/jftpgw.startscript.orig	Thu Dec 14 11:25:59 2000
+++ jftpgw-0.0.11/support/jftpgw.startscript	Thu Dec 14 13:20:14 2000
@@ -8,6 +8,8 @@
 # description: JFTPGW Proxy/Gateway 
 #
 # processname: jftpgw
+#
+# chkconfig: 345 95 05
 
 
 # Source function library.
@@ -17,7 +19,7 @@
 case "$1" in
   start)
 	echo -n "Starting JFTPGW: "
-	daemon /usr/local/bin/jftpgw
+	daemon /usr/sbin/jftpgw
 	touch /var/lock/subsys/jftpgw
 	echo
 	;;

END
}
getpatch10 | patch -p1 


%build
CFLAGS=$RPM_OPT_FLAGS ./configure --prefix=%{prefix} --with-logpath=/var/log --with-confpath=/etc --bindir=%{prefix}/sbin
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT
install jftpgw $RPM_BUILD_ROOT%{prefix}/sbin/jftpgw
cp jftpgw.access.sample $RPM_BUILD_ROOT/etc/jftpgw.access
cp jftpgw.conf.sample $RPM_BUILD_ROOT/etc/jftpgw.conf
install -d $RPM_BUILD_ROOT/etc/rc.d/init.d
cp support/jftpgw.startscript $RPM_BUILD_ROOT/etc/rc.d/init.d/jftpgw

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc COPYING README
%attr(0750,root,root) %{prefix}/sbin/jftpgw
%attr(0640,root,root) %config(noreplace) /etc/jftpgw.access
%attr(0640,root,root) %config(noreplace) /etc/jftpgw.conf
%attr(0750,root,root) %config /etc/rc.d/init.d/jftpgw

