%define version 0.44.2
## Note next line needs commenting for releases
%define prever -pre3
%define relver 1
Name: nut
Group: Applications/System
Summary: Multi-vendor UPS Monitoring Project Client Utilities
Version: %{version}
Release: %{relver}
Source: http://www.exploits.org/nut/release/%{name}-%{version}%{prever}.tar.gz
Copyright: GPL
BuildRoot: /var/tmp/%{name}-%{version}-root
Prereq: chkconfig fileutils
Obsoletes: nut-client
#
# configure file locations
# confdir etc are not really negotiable, so are not configurable here
%define STATEPATH  	/var/state/ups
%define CGIPATH   	/usr/lib/ups/cgi-bin
%define MODELPATH	/sbin
%define CONFPATH	/etc/ups


%description
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package includes the client utilities that are required to monitor a
UPS that the client host is powered from - either connected directly via
a serial port (in which case the main nut package needs to be installed on
this machine) or across the network (where another host on the network
monitors the UPS via serial cable and runs the main nut package to allow
clients to see the information).

%package server
Requires: nut
Summary: Multi-vendor UPS Monitoring Project server
Group: Applications/System
Requires: nut = %{version}

%description server
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
serial ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package is the main NUT upsd daemon and the associated per-UPS-model
drivers which talk to the UPSes.  You also need to install the base NUT
package.

%package cgi
Group: Applications/System
Summary: CGI utils for Multi-vendor UPS Monitoring Project
Requires: gd >= 1.6

%description cgi
These programs are part of a developing project to monitor the assortment 
of UPSes that are found out there in the field. Many models have serial 
serial ports of some kind that allow some form of state checking. This
capability has been harnessed where possible to allow for safe shutdowns, 
live status tracking on web pages, and more.

This package adds the web CGI programs.   These can be installed on a
separate machine to the rest of the NUT package.


%prep
%setup -q
autoconf

%build
autoconf
CFLAGS="$RPM_OPT_FLAGS" ./configure \
	--prefix=/usr \
	--exec-prefix=/usr \
	--sysconfdir=%{CONFPATH} \
	--with-statepath=%{STATEPATH} \
	--with-modelpath=%{MODELPATH} \
	--with-cgipath=%{CGIPATH} \
	--with-user=nobody \
	--with-group=nobody
make

%install
rm -rf %{buildroot}
#
# Build basic directories here - if they exist already then the
# installer doesn't try to create and chown them (the chown is
# a killer if we are building as non-root
mkdir -p %{buildroot}%{CONFPATH}
mkdir -p %{buildroot}%{MODELPATH}
mkdir -p %{buildroot}%{CGIPATH}
mkdir -p %{buildroot}%{STATEPATH}
mkdir -p %{buildroot}/usr/bin
mkdir -p %{buildroot}/usr/sbin
make INSTALLROOT=%{buildroot} install
make INSTALLROOT=%{buildroot} install-cgi

# RH config dir
mkdir -p %{buildroot}/etc/sysconfig
install -m644 scripts/RedHat-6.0/ups-config %{buildroot}/etc/sysconfig/ups

# install SYSV init stuff
mkdir -p %{buildroot}/etc/rc.d/init.d
install scripts/RedHat-6.0/upsd %{buildroot}/etc/rc.d/init.d
install scripts/RedHat-6.0/upsmon %{buildroot}/etc/rc.d/init.d
install scripts/RedHat-6.0/upspowerdown %{buildroot}/etc/rc.d/init.d

%preun
# only do this if it is not an upgrade
if [ $1 -eq 0 ]
then 
   /sbin/chkconfig --del upsmon
   [ -f /etc/rc.d/init.d/upsmon ] && \
   	/etc/rc.d/init.d/upsmon stop
fi

%post
/sbin/chkconfig --add upsmon
# restart server if this is an upgrade
if [ $1 -gt 1 ]
then
   [ -f /etc/rc.d/init.d/upsmon ] && \
   	/etc/rc.d/init.d/upsmon restart
fi


%preun server
# only do this if it is not an upgrade
if [ $1 -eq 0 ]
then 
   /sbin/chkconfig --del upspowerdown
   /sbin/chkconfig --del upsd
   [ -f /etc/rc.d/init.d/upsd ] && \
   	/etc/rc.d/init.d/upsd stop
fi

%post server
/sbin/chkconfig --add upspowerdown
/sbin/chkconfig --add upsd
# restart server if this is an upgrade
if [ $1 -gt 1 ]
then
   [ -f /etc/rc.d/init.d/upsd ] && \
   	/etc/rc.d/init.d/upsd restart
fi

%clean
rm -rf %{buildroot}

%files server
%defattr(-,root,root)
%{MODELPATH}
/usr/sbin/upsd
%attr(755,root,root) /etc/rc.d/init.d/upspowerdown
%attr(755,root,root) /etc/rc.d/init.d/upsd
%config(noreplace) %attr(600,root,root) %{CONFPATH}/upsd.conf

%files
%defattr(-,root,root)
%doc COPYING CREDITS Changes QUICKSTART README docs/*
%dir %{CONFPATH}
%config(noreplace) %attr(644,root,root) %{CONFPATH}/hosts.conf
%config(noreplace) %attr(600,root,root) %{CONFPATH}/upsmon.conf
##%config(noreplace) %attr(644,root,root) /etc/sysconfig/ups
%dir %attr(755,nobody,nobody) %{STATEPATH}
%attr(755,root,root) /etc/rc.d/init.d/upsmon
/usr/bin/upsc
/usr/bin/upscmd
/usr/bin/upsct
/usr/bin/upsct2
/usr/bin/upslog
/usr/sbin/upsmon
/usr/sbin/upssched

%files cgi
%defattr(-,root,root)
%config(noreplace) %attr(644,root,root) %{CONFPATH}/multimon.conf
%config(noreplace) %attr(600,nobody,root) %{CONFPATH}/upsset.passwd
%config(noreplace) %attr(644,root,root) %{CONFPATH}/hosts.conf
%dir %{CGIPATH}
%{CGIPATH}/multimon.cgi
%{CGIPATH}/upsimage.cgi
%{CGIPATH}/upsset.cgi
%{CGIPATH}/upsstats.cgi


%changelog
* Tue Dec 05 2000 <Nigel.Metheringham@InTechnology.co.uk> (0.44.2)
- Made cgi package standalone (needs no other parts of NUT)
- Moved some configs into cgi
- Shared hosts.conf between cgi & main

* Fri Nov 24 2000 <Nigel.Metheringham@InTechnology.co.uk> (0.44.2)
- Moved models to be more FHS compliant and make sure they are there
  if everything but root is unmounted
- Moved a few things around

* Mon Aug 21 2000 <Nigel.Metheringham@Vdata.co.uk> (0.44.1)
- Added new model drivers into rpm list
- Made it wildcard more stuff so this doesn't need to be
  maintained for every little change.
  ** NOTE this breaks things if modelpath isn't distinct **

* Mon Jul 17 2000 <Nigel.Metheringham@Vdata.co.uk> (0.44.0)
- Fixed some problems in the spec file
- Dropped the older changelog entries since there is some
  intermediate history thats been missed.
- Added new model drivers into rpm list
- Updated descriptions somewhat

