/* common.c - common useful functions

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>

#include "config.h"
#include "proto.h"

/* close ttys and become a daemon */
void background()
{
	int	pid;

	if ((pid = fork()) < 0) {
		perror ("Unable to enter background");
		exit (1);
	}

	close (0);
	close (1);
	close (2);

	if (pid != 0) 
		exit (0);		/* parent */

	/* child */

	/* make fds 0-2 point somewhere defined */
	(void) open ("/dev/null", O_RDWR);
	dup (0);
	dup (0);

#ifdef HAVE_SETSID
	setsid();		/* make a new session to dodge signals */
#endif

	syslog (LOG_INFO, "Startup successful");
}

/* change uid/gid if running as root */
void droproot ()
{
    struct passwd *usr;
    struct group  *grp;

    int uid;
    int gid;

	if (getuid() == 0)
    {
        /* determine the uid */
        if ((usr = getpwnam (RUN_AS_USER)) == NULL) {
            fprintf (stderr, "getpwnam() failed: user %s does not exist\n",
                    RUN_AS_USER);
            exit(1);
        }
        uid = usr->pw_uid;

        /* determine the gid */
        if ((grp = getgrnam (RUN_AS_GROUP)) == NULL) {
            fprintf (stderr, "getgrnam() failed: group %s does not exist\n",
                    RUN_AS_GROUP);
            exit(1);
        }
        gid = grp->gr_gid;

        /* change gid first, while we are still root */
        if (setgid (gid) == -1) {
            perror ("setgid");
            exit(1);
        }

        /* change uid second */
		if (setuid (uid) == -1) {
			perror ("setuid");
			exit (1);
		}
    }
}

int parseconf (char *fn, int ln, char *buf, char **arg, int numargs)
{
	char	*ptr, *sp, *dq;
	int	i;

	ptr = buf;

	for (i = 0; i < numargs; i++) {
		arg[i] = ptr;

		if (!ptr)
			continue;

		if (arg[i][0] == '"') {
			dq = strchr (&arg[i][1], '"');

			if (!dq) {
				printf ("%s:%d: Unbalanced \" in line\n", fn, ln);
				return 0;	/* FAILED */
				break;
			}

			*dq = '\0';
			arg[i]++;
			ptr = dq + 1;
		}

		sp = strchr (ptr, ' ');

		if (sp) {
			*sp = '\0';
			ptr = sp + 1;
		}
		else
			ptr = NULL;
	}

	return 1;	/* success */
}
