/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.webapp.admin.TreeControl;

public class TreeControlNode
implements Serializable {
    protected ArrayList children = new ArrayList();
    protected String action = null;
    protected String domain = null;
    protected boolean expanded = false;
    protected String icon = null;
    protected String label = null;
    protected boolean last = false;
    protected String name = null;
    protected TreeControlNode parent = null;
    protected boolean selected = false;
    protected String target = null;
    protected TreeControl tree = null;
    protected int width = 0;

    public TreeControlNode(String name, String icon, String label, String action, String target, boolean expanded, String domain) {
        this.name = name;
        this.icon = icon;
        this.label = label;
        this.action = action;
        this.target = target;
        this.expanded = expanded;
        this.domain = domain;
    }

    public String getAction() {
        return this.action;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLast() {
        return this.last;
    }

    void setLast(boolean last) {
        this.last = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.size() < 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public TreeControlNode getParent() {
        return this.parent;
    }

    void setParent(TreeControlNode parent) {
        this.parent = parent;
        this.width = parent == null ? 1 : parent.getWidth() + 1;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getTarget() {
        return this.target;
    }

    public TreeControl getTree() {
        return this.tree;
    }

    void setTree(TreeControl tree) {
        this.tree = tree;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TreeControlNode child) throws IllegalArgumentException {
        this.tree.addNode(child);
        child.setParent(this);
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = this.children.size();
            if (n > 0) {
                TreeControlNode node = (TreeControlNode)this.children.get(n - 1);
                node.setLast(false);
            }
            child.setLast(true);
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(int offset, TreeControlNode child) throws IllegalArgumentException {
        this.tree.addNode(child);
        child.setParent(this);
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(offset, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeControlNode[] findChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            TreeControlNode[] results = new TreeControlNode[this.children.size()];
            return this.children.toArray(results);
        }
    }

    public void remove() {
        if (this.tree != null) {
            this.tree.removeNode(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(int offset) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            TreeControlNode child = (TreeControlNode)this.children.get(offset);
            this.tree.removeNode(child);
            child.setParent(null);
            this.children.remove(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(TreeControlNode child) {
        if (child == null) {
            return;
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                if (child != (TreeControlNode)this.children.get(i)) continue;
                this.children.remove(i);
                return;
            }
        }
    }
}

