/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.util.LazyFileOutputStream;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class Redirector {
    private File out;
    private File error;
    private File input;
    private boolean logError = false;
    private ByteArrayOutputStream baos = null;
    private ByteArrayOutputStream errorBaos = null;
    private String outputProperty;
    private String errorProperty;
    private String inputString;
    private boolean append = false;
    private Task managingTask;
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    private InputStream inputStream = null;
    private PrintStream outPrintStream = null;
    private PrintStream errorPrintStream = null;

    public Redirector(Task managingTask) {
        this.managingTask = managingTask;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setOutput(File out) {
        this.out = out;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    private void setPropertyFromBAOS(ByteArrayOutputStream baos, String propertyName) throws IOException {
        BufferedReader in = new BufferedReader(new StringReader(Execute.toString(baos)));
        String line = null;
        StringBuffer val = new StringBuffer();
        while ((line = in.readLine()) != null) {
            if (val.length() != 0) {
                val.append(StringUtils.LINE_SEP);
            }
            val.append(line);
        }
        this.managingTask.getProject().setNewProperty(propertyName, val.toString());
    }

    public void createStreams() {
        if (this.out == null && this.outputProperty == null) {
            this.outputStream = new LogOutputStream(this.managingTask, 2);
            this.errorStream = new LogOutputStream(this.managingTask, 1);
        } else {
            if (this.out != null) {
                this.outputStream = new LazyFileOutputStream(this.out, this.append);
                this.managingTask.log("Output redirected to " + this.out, 3);
            }
            if (this.outputProperty != null) {
                this.baos = new ByteArrayOutputStream();
                this.managingTask.log("Output redirected to property: " + this.outputProperty, 3);
                this.outputStream = this.out == null ? this.baos : new TeeOutputStream(this.outputStream, this.baos);
            } else {
                this.baos = null;
            }
            this.errorStream = this.outputStream;
        }
        if (this.logError) {
            this.errorStream = new LogOutputStream(this.managingTask, 1);
        }
        if (this.error != null) {
            this.errorStream = new LazyFileOutputStream(this.error, this.append);
            this.managingTask.log("Error redirected to " + this.error, 3);
        }
        if (this.errorProperty != null) {
            this.errorBaos = new ByteArrayOutputStream();
            this.managingTask.log("Error redirected to property: " + this.errorProperty, 3);
            this.errorStream = this.error == null ? this.errorBaos : new TeeOutputStream(this.errorStream, this.errorBaos);
        } else {
            this.errorBaos = null;
        }
        if (this.input != null && this.inputString != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        if (this.input != null) {
            try {
                this.inputStream = new FileInputStream(this.input);
            }
            catch (FileNotFoundException fne) {
                throw new BuildException("Cannot read from " + this.input, fne);
            }
        } else if (this.inputString != null) {
            this.inputStream = new ByteArrayInputStream(this.inputString.getBytes());
        }
    }

    public ExecuteStreamHandler createHandler() throws BuildException {
        this.createStreams();
        return new PumpStreamHandler(this.outputStream, this.errorStream, this.inputStream);
    }

    protected void handleOutput(String output) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(output);
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.inputStream == null) {
            return this.managingTask.getProject().defaultInput(buffer, offset, length);
        }
        return this.inputStream.read(buffer, offset, length);
    }

    protected void handleFlush(String output) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(output);
        this.outPrintStream.flush();
    }

    protected void handleErrorOutput(String output) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(output);
    }

    protected void handleErrorFlush(String output) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(output);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void complete() throws IOException {
        System.out.flush();
        System.err.flush();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream instanceof LazyFileOutputStream) {
            ((LazyFileOutputStream)this.outputStream).open();
        }
        this.outputStream.close();
        if (this.errorStream != this.outputStream) {
            if (this.errorStream instanceof LazyFileOutputStream) {
                ((LazyFileOutputStream)this.errorStream).open();
            }
            this.errorStream.close();
        }
        if (this.baos != null) {
            this.setPropertyFromBAOS(this.baos, this.outputProperty);
        }
        if (this.errorBaos != null) {
            this.setPropertyFromBAOS(this.errorBaos, this.errorProperty);
        }
    }
}

