/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool _pool = null;

    public PoolableConnection(Connection conn, ObjectPool pool) {
        super(conn);
        this._pool = pool;
    }

    public PoolableConnection(Connection conn, ObjectPool pool, AbandonedConfig config) {
        super(conn, config);
        this._pool = pool;
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Already closed.");
        }
        try {
            this._pool.returnObject((Object)this);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot close connection (return to pool failed)", e);
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

