// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "message.h"
#include "mailbox.h"
#include "newsgroup.h"
#include "composition.h"
#include "boxlist.h"

// Functional interface to LISP interpretor
typedef int config_error;
void config_init(void);
const char *config_get_string(const char *);
const char *config_filename_to_mimetype(const char *);
bool config_handle_attachment(const char *, const char *, const char *);
bool config_get_bool(const char *);

// Top-level menus
void tty_grin_menu(void);
void tty_grin_imap4(void);
void tty_grin_addresses(void);
void tty_grin_news(void);

// object& browsing functions
void tty_grin_mail(boxlist&, const char *);
void tty_grin_mailbox(mailbox&, const char *);
void tty_grin_newsgroup(newsgroup&);
void tty_grin_message(message&, message_descriptor&);
void tty_grin_composition(composition&, const char *);

// Popup menu functions
mailbox *tty_grin_mail_choose(void);
bool tty_grin_addresses_choose(string&);
