// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <fstream>
#include "tgws.h"
#include "unix.h"

void
usage(const char *name) {
  cerr<<name<<_(" [options] [address]
    -version          Displays the version of TTY-Grin and exits.
    -nocolor          Suppress color usage.
    -resume <file>    Resume a postponed message from file.
    -subject <text>   Set the subject for a new message.
");
  exit(-1);
}

int
main(int argc, char *argv[]) {
  const char *mailto=0, *resume=0, *subject=0;

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);

  for(int i=1;i<argc;i++) {
    if(*argv[i]=='-') {
      if(!strcmp(argv[i], "-version")) {
	cout<<_("TTY-Grin version ")<<VERSION<<endl;
	cout<<_("Copyright (C) 2001 Daniel Beer")<<endl;
	cout<<_("
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
");
	return 0;
      } else if(!strcmp(argv[i], "-nocolor")) tgws::use_color=false;
      else if(!strcmp(argv[i], "-resume")) {
	if(++i>=argc) usage(argv[0]);
	resume=argv[i];
      } else if(!strcmp(argv[i], "-subject")) {
	if(++i>=argc) usage(argv[0]);
	subject=argv[i];
      } else usage(argv[0]);
    } else {
      if(mailto) usage(argv[0]);
      else mailto=argv[i];
    }
  }

  if(resume) {
    ifstream in(resume);
    if(in.good()) {
      composition resume;
      char buffer[1024];
      in.getline(buffer, sizeof(buffer));
      while(!in.fail()&&buffer[0]) {
	char *x=strchr(buffer, ':');
	if(x) {
	  *(x++)=0;
	  resume.set_header(buffer, ++x);
	}
	in.getline(buffer, sizeof(buffer));
      }
      resume.append(in);
      in.close();
      tgws::init();
      config_init();
      tty_grin_composition(resume, _("Postponed message"));
      tgws::end();
      return 0;
    }
    perror(resume);
  }

  if(mailto) {
    composition c;
    c.set_header("To", argv[1]);
    if(subject) c.set_header("Subject", subject);
    tgws::init();
    config_init();
    try {
      ifstream signature(config_get_string("SIGNATURE"));
      if(signature.good()) {
	c.append("\n\n--\n");
	c.append(signature);
	signature.close();
      }
    }
    catch(config_error e) { }    
    tty_grin_composition(c, argv[1]);
    tgws::end();
    return 0;
  }

  tgws::init();
  config_init();
  tty_grin_menu();
  tgws::end();
  return 0;
}
