// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  enum halign {LEFT, RIGHT, CENTER};
  enum valign {TOP, BOTTOM, MIDDLE};

  class widget {
  public:
    widget(void);
    virtual ~widget(void);

    virtual void draw(bool=false);
    virtual void size(int, int);
    virtual void position(int, int);
    virtual void show(void);
    virtual void hide(void);

    int get_height(void) const { return height; }
    int get_width(void) const { return width; }
    int get_line(void) const { return line; }
    int get_column(void) const { return column; }
    void display(void) {
      if(visible&&my_screen==active_screen) {
	redrawwin(win);
	wnoutrefresh(win);
      }
    }

  protected:
    int height, width, line, column;
    WINDOW *win;
    style *look;
    bool visible;

  private:
    list<widget *>::iterator sit;
    screen *my_screen;
  };
};
