// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

tgws::widget::widget(void) : height(0), width(0), line(0), column(0),
			     look(&default_style), visible(false),
                             sit(active_screen->add_widget(this)),
			     my_screen(active_screen) {
  win=newwin(0, 0, 0, 0);
  keypad(win, true);
  draw();
}

tgws::widget::~widget(void) {
  hide();
  my_screen->remove_widget(sit);
}

void
tgws::widget::size(int h, int w) {
  height=h;
  width=w;
  delwin(win);
  win=newwin(h, w, line, column);
  keypad(win, true);
  if(visible&&my_screen==active_screen&&h<height||w<width)
    my_screen->display();
  draw();
}

void
tgws::widget::position(int l, int c) {
  line=l;
  column=c;
  mvwin(win, l, c);
  if(visible&&my_screen==active_screen) my_screen->display();
  draw();
}

void
tgws::widget::draw(bool running) {
  display();
}

void
tgws::widget::show(void) {
  visible=true;
  display();
}

void
tgws::widget::hide(void) {
  visible=false;
  my_screen->display();
}
