// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  enum which_style {
    TEXT=0,
    ENTRY=1,
    ENTRY_DISABLED=2,
    LIST=3,
    SELECTION=4,
    TITLE=5,
    EDIT=6,
    MENU=7,
    FRAME=8,
    KEY=9,
    QUOTED=10,
    SIGNATURE=11
  };

  class style {
  public:
    void init(void);

    void set_attr(enum which_style which, int what) { attr[which]=what; }
    int get_attr(enum which_style which) const {
      return use_color?attr[which]:attr[which]&(A_BOLD|A_REVERSE);
    }

  private:
    int attr[12];
  };
};
