// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

tgws::screen *tgws::active_screen=new tgws::screen;

tgws::screen::~screen(void) {
  while(!widgets.empty()) delete *widgets.begin();
}

void
tgws::screen::redraw(void) {
  // Does this actually work?
  clear();
  display();
}

void
tgws::screen::display(void) {
  bkgdset(default_style.get_attr(TEXT));
  werase(stdscr);
  wnoutrefresh(stdscr);
  for(list<widget *>::iterator i=widgets.begin();i!=widgets.end();++i)
    (*i)->display();
}

void
tgws::screen::push(void) {
  active_screen=new screen;
  active_screen->old=this;
  active_screen->display();
}

void
tgws::screen::pop(void) {
  if(old) active_screen=old;
  delete this;
  active_screen->display();
}
