// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class pinemenu : public input {
  public:
    struct item {
      int key;
      string left, right;
    };

    pinemenu(void) : spacing(2) { current=items.end(); }
    
    virtual int run(void);
    virtual void draw(bool=false);

    int get_spacing(void) const { return spacing; }
    void set_spacing(int s) { spacing=s; }

    int get_left(void) const { return left; }
    void set_left(int l) { left=l; }
    
    void add_item(int, const char *, const char *);

  private:
    int spacing, left;
    list<item> items;
    list<item>::const_iterator current;
  };
};
