// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class pilot : public input {
  public:
    pilot(void);

    virtual void size(int, int);
    virtual void position(int, int);
    virtual int run(void);
    virtual void draw(bool=false);
    virtual void show(void);
    virtual void hide(void);

    const char *get_filename(void) const { return filename.get_text(); }
    void set_filename(const char *what) { filename.set_text(what); }

  protected:
    bool files, textentry;
    int savedir;
    clist dir, file;
    title dirname;
    label prompt;
    entry filename;

    void browse(void);
    void swapdir(void);
  };
};
