// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

void
tgws::password::draw(bool running) {
  if(cursor<scr||scr+(width-2)<cursor) {
    if(cursor>((unsigned)width-2)/2) scr=cursor-(width-2)/2;
    else scr=0;
  }
  wbkgdset(win, look->get_attr(enabled?ENTRY:ENTRY_DISABLED));
  werase(win);
  waddch(win, scr?'<':' ');
  for(const char *x=text.c_str()+scr;*x;x++) waddch(win, '*');
  mvwaddch(win, 0, width-1, scr+(width-2)<text.size()?'>':' ');
  mvwaddstr(win, 0, cursor-scr+1, "");
  input::draw();
}
