// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

void
tgws::label::draw(bool running) {
  if(!width) return;
  wbkgdset(win, look->get_attr(TEXT));
  werase(win);
  const char *start=text.c_str();
  int line=0;
  while(*start) {
    int i, j;
    for(i=0;start[i]&&start[i]!='\n'&&i<width;i++);
    int column=0;
    switch(align) {
    case LEFT: column=0; break;
    case RIGHT: column=width-i; break;
    case CENTER: column=(width-i)/2; break;
    }
    mvwaddstr(win, line++, column, "");
    for(j=0;j<i;j++) waddch(win, (unsigned char)start[j]);
    start+=i;
    if(*start=='\n') start++;
  }
  widget::draw();
}
