// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lisp.h"

lisp::structure::structure(const char *t,
			   const structdef *d) : variable("STRUCTURE"),
						 type(t),
						 definition(d),
						 num(d->size()) {
  elements=new weak_object[num];
}

lisp::structure::~structure(void) {
  delete[] elements;
}

bool
lisp::structure::equal(object x) const {
  if(!(is_structure(x)&&assume_structure(x).definition==definition&&
       assume_structure(x).num==num))
    return false;
  for(int i=0;i<num;i++)
    if(!elements[i].equal(assume_structure(x).elements[i])) return false;
  return true;
}

string
lisp::structure::print(void) const {
  string out("#S(");
  out+=type;
  for(int i=0;i<num&&i<(signed)definition->size();i++) {
    out+=" :";
    out+=(*definition)[i];
    out+=' ';
    out+=elements[i].print();
  }
  out+=')';
  return out;
}

int
lisp::structure::recursive_mark(void) {
  if(get_mark()) return 0;
  int total=1;
  set_mark(true);

  for(int i=0;i<num;i++)
    if(!elements[i].get_const_data()->get_mark())
      total+=elements[i].get_data()->recursive_mark();

  return total;
}
