// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <string.h>
#include <list>
#include "lisp.h"

string
lisp::real_function::print(void) const {
  string out("#<FUNCTION ");
  out+=name.print();
  for(int i=0;i<size();i++) {
    out+=' ';
    out+=content[i].print();
  }
  out+='>';
  return out;
}

lisp::object
lisp::real_function::funcall(library& l, int argc, object *argv) {
  if(size()<2) throw error(object(this), _("Syntax error"));
  domain d(l);

  {
    list<object> given;
    for(int i=0;i<argc;i++) given.push_back(argv[i]);
    const char *text="";
    object x;

    // &key
    for(x=content[0];
	is_cons(x)&&
	  !(is_atom(assume_cons(x).car)&&
	    !strcmp(assume_atom(assume_cons(x).car).get_text(), "&KEY"));
	x=assume_cons(x).cdr);
    if(is_cons(x)) {
      x=assume_cons(x).cdr;
      while(is_cons(x)&&
	    !(is_atom(assume_cons(x).car)&&
	      (*(assume_atom(assume_cons(x).car).get_text())=='&'))) {
	object p=assume_cons(x).car, def;
	const char *name;

	if(is_atom(p)) name=assume_atom(p).get_text();
	else {
	  name=as_atom(as_cons(p).car).get_text();
	  def=assume_cons(p).cdr;
	  if(is_cons(def)) {
	    domain glob(l);
	    def=l.evaluate(glob, assume_cons(def).car);
	  }
	}

	for(list<object>::iterator i=given.begin();i!=given.end();i++) {
	  if(is_atom(*i)) {
	    const char *x=assume_atom(*i).get_text();
	    if(*x==':'&&!strcmp(x+1, name)) {
	      list<object>::iterator j=i;
	      if(++j==given.end())
		throw error(object(this), _("Insufficient arguments"));
	      def=*j;
	      given.erase(i);
	      given.erase(j);
	      i=given.end();
	    }
	  }
	}

	d.lex(name, def);
	
	x=assume_cons(x).cdr;
      }      
    }

    // Required arguments
    for(x=content[0];
	is_cons(x)&&is_atom(assume_cons(x).car)&&
	  *(text=assume_atom(assume_cons(x).car).get_text())!='&';
	x=assume_cons(x).cdr) {
      if(!given.size()) throw error(object(this), _("Insufficient arguments"));
      d.lex(text, given.front());
      given.pop_front();
    }

    // &optional
    for(x=content[0];
	is_cons(x)&&
	  !(is_atom(assume_cons(x).car)&&
	    !strcmp(assume_atom(assume_cons(x).car).get_text(), "&OPTIONAL"));
	x=assume_cons(x).cdr);
    if(is_cons(x)) {
      x=assume_cons(x).cdr;
      while(is_cons(x)&&
	    !(is_atom(assume_cons(x).car)&&
	      (*(assume_atom(assume_cons(x).car).get_text())=='&'))) {
	object p=assume_cons(x).car;
	if(is_atom(p)) {
	  if(given.size()) {
	    d.lex(assume_atom(p).get_text(), given.front());
	    given.pop_front();
	  } else d.lex(assume_atom(p).get_text());
	} else {
	  if(given.size()) {
	    d.lex(as_atom(as_cons(p).car).get_text(), given.front());
	    given.pop_front();
	  } else {
	    object def=as_cons(p).cdr;
	    if(is_cons(def))
	      d.lex(as_atom(assume_cons(p).car).get_text(),
		    l.evaluate(d, assume_cons(def).car));
	    else d.lex(as_atom(assume_cons(p).car).get_text());
	  }
	}
	x=assume_cons(x).cdr;
      }
    }

    // &rest
    for(x=content[0];
	is_cons(x)&&
	  !(is_atom(assume_cons(x).car)&&
	    !strcmp(assume_atom(assume_cons(x).car).get_text(), "&REST"));
	x=assume_cons(x).cdr);
    if(is_cons(x)) {
      x=assume_cons(x).cdr;
      text=as_atom(as_cons(x).car).get_text();
      x=nil;
      while(given.size()) {
	x=object(new cons(given.back(), x));
	given.pop_back();
      }
      d.lex(text, x);
    }

    if(given.size()) throw error(object(this), _("Excess arguments"));
  }

  if(size()<2) return nil;

  try {
    for(int i=1;i<size()-1;i++) l.evaluate(d, content[i]);
    return l.evaluate(d, content[size()-1]);
  }
  catch(return_from r) {
    if(r.get_block_name().equal(name)) return r.get_value();
    throw r;
  }
}

bool
lisp::real_function::equal(object x) const {
  return x.get_const_data()==this;
}

int
lisp::real_function::recursive_mark(void) {
  if(get_mark()) return 0;
  int total=1;
  set_mark(true);

  if(!name.get_const_data()->get_mark())
    total+=name.get_data()->recursive_mark();

  for(vector<weak_object>::iterator i=content.begin();i!=content.end();i++)
    if(!(*i).get_const_data()->get_mark())
      total+=(*i).get_data()->recursive_mark();

  return total;
}
