// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class function : public variable {
  public:
    function(void) : variable("FUNCTION") { }
    virtual object funcall(library&, int, object *)=0;
  };

  inline bool is_function(const object o) {
    return dynamic_cast<const function *>(o.get_const_data())!=0;
  }

  inline function& assume_function(object o) {
    return *(function *)o.get_data();
  }

  inline function& as_function(object o) {
    function *f=dynamic_cast<function *>(o.get_data());
    if(f) return *f;
    throw error(o, _("Type mismatch"));
  }
};
