// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lisp.h"

lisp::domain::~domain(void) {
  map<string, pair<object, bool>, lt_string>::const_iterator i;

  for(i=lexical.begin();i!=lexical.end();i++)
    if((*i).second.second)
      global->set_variable((*i).first.c_str(), (*i).second.first);
}

void
lisp::domain::lex(const char *name, object value) {
  string s(name);
  if(global->is_dynamic(name)) {
    lexical[s]=pair<object, bool>(global->get_variable(name), true);
    global->set_variable(name, value);
  } else lexical[s]=pair<object, bool>(value, false);
}

lisp::object
lisp::domain::get(const char *name) {
  string s(name);
  map<string, pair<object, bool>, lt_string>::const_iterator i;

  if((i=lexical.find(s))==lexical.end())
    return parent?parent->get(name):global->get_variable(name);
  if((*i).second.second) return global->get_variable(name);
  return (*i).second.first;
}

lisp::object *
lisp::domain::get_reference(const char *name) {
  string s(name);
  map<string, pair<object, bool>, lt_string>::iterator i;

  if((i=lexical.find(s))==lexical.end())
    return parent?parent->get_reference(name):
    global->get_variable_reference(name);
  if((*i).second.second) return global->get_variable_reference(name);
  return &(*i).second.first;
}

void
lisp::domain::set(const char *name, object value) {
  string s(name);
  map<string, pair<object, bool>, lt_string>::iterator i;

  if((i=lexical.find(s))==lexical.end()) {
    if(parent) parent->set(name, value);
    else global->set_variable(name, value);
  } else if((*i).second.second)
    global->set_variable(name, value);
  else (*i).second.first=value;
}
