// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include "lisp.h"

lisp::array::array(const array& a) : variable("ARRAY"),
				     numd(a.numd), totalsize(a.totalsize) {
  dimensions=new int[numd];
  for(int i=0;i<numd;i++) dimensions[i]=a.dimensions[i];
  data=new weak_object[totalsize];
  for(int i=0;i<totalsize;i++) data[i]=a.data[i];
}

lisp::array::~array(void) {
  delete[] dimensions;
  delete[] data;
}

void
lisp::array::allocate(void) {
  totalsize=1;
  for(int i=0;i<numd;i++) totalsize*=dimensions[i];
  data=new weak_object[totalsize];
}

string
lisp::array::print(void) const {
  char tmp[32];

  sprintf(tmp, "#%dA", numd);
  string out(tmp);
  if(totalsize) printhelp(out, 0, 0, totalsize);
  return out;
}

bool
lisp::array::equal(object x) const {
  if(!is_array(x)||assume_array(x).numd!=numd) return false;
  for(int i=0;i<numd;i++)
    if(dimensions[i]!=assume_array(x).dimensions[i]) return false;
  for(int i=0;i<totalsize;i++)
    if(!data[i].equal(assume_array(x)[i])) return false;
  return true;
}

void
lisp::array::printhelp(string& out, int dim, int start, int size) const {
  int psize=size/dimensions[dim];

  out+='(';
  if(dim==numd-1) {
    out+=data[start].print();
    for(int i=1;i<dimensions[dim];i++) {
      out+=' ';
      out+=data[start+i].print();
    }
  } else {
    printhelp(out, dim+1, start, psize);
    for(int i=1;i<dimensions[dim];i++) {
      out+=' ';
      printhelp(out, dim+1, start+i*psize, psize);
    }
  }
  out+=')';
}

int
lisp::array::recursive_mark(void) {
  if(get_mark()) return 0;
  int total=1;
  set_mark(true);

  for(int i=0;i<totalsize;i++)
    if(!data[i].get_const_data()->get_mark())
      total+=data[i].get_data()->recursive_mark();

  return total;
}
