; 100 people are standing in a circle.  Beginning with the first, every
; 5th person is removed.  This continues until only one person is left. What
; was the original position in the circle of the remaining member?

(defun create-circle (size)
  (let* ((circle (cons 1 nil)) (end circle))
    (do ((x 2 (+ x 1))) ((> x size))
	(setf (cdr end) (cons x nil))
	(setq end (cdr end)))
    (setf (cdr end) circle)
    (return-from create-circle circle)))

(defun eliminate (count circle)
  (let ((mark circle))
    (loop
     (when (eq mark (cdr mark))
       (return-from eliminate (car mark)))
     (do ((x 3 (+ x 1))) ((> x count)) (setq mark (cdr mark)))
     (setf (cdr mark) (cdr (cdr mark)))
     (setq mark (cdr mark)))))

(print (eliminate 5 (create-circle 100)))
