// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "tempfile.h"

tempfile::tempfile(void) {
  char ntf[]="/tmp/tty-grin.XXXXXXXXXX";
  int fd;

  fd=mkstemp(ntf);
  close(fd);
  source_filename=new char[strlen(ntf)+1];
  strcpy(source_filename, ntf);
  ref=new int(1);
}

tempfile::~tempfile(void) {
  if(!--(*ref)) {
    unlink(source_filename);
    delete ref;
    delete source_filename;
  }
}

tempfile::tempfile(const tempfile& src) {
  source_filename=src.source_filename;
  (*(ref=src.ref))++;
}

tempfile&
tempfile::operator=(const tempfile& src) {
  if(!--(*ref)) {
    unlink(source_filename);
    delete ref;
    delete source_filename;
  }  
  source_filename=src.source_filename;
  (*(ref=src.ref))++;
  return *this;
}
