// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "mime.h"
#include <string.h>
#include <ctype.h>

const char *
mime_part::operator[](const char *name) const {
  map<string, string, lt_string>::const_iterator x=headers.find(string(name));
  if(x==headers.end()) return "";
  else return (*x).second.c_str();
}

void
mime_part::add_header(const string& h) {
  string::size_type i, j;

  for(i=0;i<h.size()&&h[i]!=':'&&!isspace(h[i]);i++);
  if(isspace(h[i])) return;

  string base_name(h, 0, i);
  for(j=0;j<base_name.size();j++) base_name[j]=tolower(base_name[j]);

  i+=2;
  for(j=i;j<h.size()&&h[j]!=';';j++);
  if(j<=i) return;
  headers[base_name]=string(h, i, j-i);

  while(j+2<h.size()) {
    for(i=j+2;i<h.size()&&isspace(h[i]);i++);
    for(j=i;j<h.size()&&h[j]!='='&&!isspace(h[j]);j++);
    string sub_name(h, i, j-i);
    string::size_type x;
    for(x=0;x<sub_name.size();x++) sub_name[x]=tolower(sub_name[x]);
    while(j<h.size()&&isspace(h[j])) j++;
    if(h[j]!='=') return;
    for(i=j+1;i<h.size()&&isspace(h[i])&&h[i]!='"';i++);
    if(h[i]=='"') {
      i++;
      for(j=i;j<h.size()&&h[j]!='"';j++);
    } else for(j=i;j<h.size()&&!isspace(h[j]);j++);
    if(i<j) headers[base_name+'/'+sub_name]=string(h, i, j-i);
  }
}

void
mime_part::extract(istream& in, ostream& out) const {
  const char *ct;

  in.seekg(begin);
  ct=(*this)["content-transfer-encoding"];
  if(ct&&!strcasecmp(ct, "base64")) {
    char line[80];

    in.getline(line, sizeof(line));
    while(in.tellg()<=end&&!in.fail()) {
      int i, len=strlen(line);
      for(i=0;i<len;i+=4) {
	char a=base64_digit(line[i]);
	char b=base64_digit(line[i+1]);
	out.put((a<<2)|((b&0x30)>>4));
	if(line[i+2]!='=') {
	  char c=base64_digit(line[i+2]);
	  out.put(((b&0xf)<<4)|((c&0x3c)>>2));
	  if(line[i+3]!='=') {
	    char d=base64_digit(line[i+3]);
	    out.put(((c&0x3)<<6)|d);
	  }
	}
      }
      in.getline(line, sizeof(line));
    }
  } else if(ct&&!strcasecmp(ct, "quoted-printable")) {
    char line[80];

    in.getline(line, sizeof(line));
    while(in.tellg()<end&&!in.fail()) {
      int i;
      for(i=0;line[i];i++) {
	if(line[i]=='=') {
	  if(line[i+1]&&line[i+2]) {
	    out.put(hex_digit(line[i+1])*16+hex_digit(line[i+2]));
	    i+=2;
	  }
	} else out.put(line[i]);
      }
      if(!i||line[i-1]!='=') out<<endl;
      in.getline(line, sizeof(line));
    }
  } else {
    char c;

    in.get(c);
    while(in.tellg()<end&&!in.fail()) {
      out.put(c);
      in.get(c);
    }
  }
}

mime::mime(istream& text) {
  add_part(text);
}

bool
mime::add_part(istream& text, const char *boundary) {
  char buf[4096];
  string line;
  mime_part part;
  int which=parts.size();

  part.add_header("Content-Type: text/plain");
  text.getline(buf, sizeof(buf));
  while(!text.fail()&&buf[0]) {
    if(buf[0]=='\t') {
      line+=' ';
      line+=(buf+1);
    } else {
      if(!line.empty()) part.add_header(line);
      line.resize(0);
      line=buf;
    }
    text.getline(buf, sizeof(buf));
  }
  if(!line.empty()) part.add_header(line);
  part.begin=text.tellg();
  part.container=false;
  parts.push_back(part);

  const char *ct=part["content-type"];
  if(ct) {
    if(!strcasecmp(ct, "message/rfc822")) {
      while(text.get()!='\n');
      bool x=add_part(text, boundary);
      part.end=parts.back().end;
      part.container=true;
      parts[which]=part;
      return x;
    } else if(!strncasecmp(ct, "multipart/", 10)) {
      text.getline(buf, sizeof(buf));
      while(!text.fail()&&buf[0]!='-') text.getline(buf, sizeof(buf));
      while(add_part(text, buf));
      part.container=true;
    }
  }

  while(!text.fail()&&!(boundary&&!strncmp(buf, boundary, strlen(boundary)))) {
    part.end=text.tellg();
    text.getline(buf, sizeof(buf));
  }
  parts[which]=part;
  return boundary?buf[strlen(boundary)]==0:true;
}
