// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _MESSAGE_DESCRIPTOR_H
#define _MESSAGE_DESCRIPTOR_H

#include <iostream>
#include <string>

class message_descriptor {
public:
  enum {
    READ=0x01,
    ANSWERED=0x02,
    MARKED=0x04,
    DELETED=0x08,
    EXPUNGE=0x10
  };

  static unsigned char flags_to_status(unsigned char);

  message_descriptor(void) : flags(0) { }
  virtual ~message_descriptor(void);
  virtual bool extract(ostream&) const=0;
  unsigned char status(void) const { return flags_to_status(flags); }

  const char *get_date(void) const { return date.c_str(); }
  const char *get_from(void) const { return from.c_str(); }
  const char *get_subject(void) const { return subject.c_str(); }

  void set_date(const char *text) { date=text; }
  void set_from(const char *text) { from=text; }
  void set_subject(const char *text) { subject=text; }

  virtual void set_flags(unsigned char);
  unsigned char get_flags(void) const { return flags; }
  void set_flag(unsigned char x) { set_flags(get_flags()|x); }
  void clear_flag(unsigned char x) { set_flags(get_flags()&~x); }
  void toggle_flag(unsigned char x) { set_flags(get_flags()^x); }

private:
  unsigned char flags;
  string date, from, subject;
  static unsigned char status_flags[];
};

#endif
