// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _LOCALMAILBOX_H
#define _LOCALMAILBOX_H

#include <vector>
#include <time.h>
#include "message_descriptor.h"
#include "message.h"
#include "mailbox.h"

class localmailbox;

class localmailbox_message : public message_descriptor {
  friend localmailbox;

public:
  localmailbox_message(localmailbox *m) : parent(m) { }
  virtual bool extract(ostream&) const;
  virtual void set_flags(unsigned char);

private:
  localmailbox *parent;
  streampos begin, end;

  bool extract_real(ostream&, bool=false) const;
};

class localmailbox : public mailbox {
  friend localmailbox_message;

public:
  localmailbox(const char *);
  virtual ~localmailbox(void);
  virtual message_descriptor& operator[](int);
  virtual int size(void) const;
  virtual bool append(const message_descriptor&);
  virtual bool append(const message&, unsigned char=0);
  virtual void expunge(void);

private:
  class lt_string {
  public:
    bool operator()(const string& a, const string& b) const { return a<b; }
  };

  string source_filename;
  vector<localmailbox_message> messages;
  bool commit;

  bool is_from_line(const char *) const;

  static unsigned char status_flags[];
};

#endif
