// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _GROUPSEARCH_H
#define _GROUPSEARCH_H

#include <string>
#include <list>

class groupsearch_group {
public:
  groupsearch_group(const char *n, const char *d) : name(n), description(d) { }

  const char *get_name(void) const { return name.c_str(); }
  const char *get_description(void) const { return description.c_str(); }
  
private:
  string name, description;
};

class groupsearch {
public:
  typedef list<groupsearch_group>::iterator iterator;
  typedef list<groupsearch_group>::const_iterator const_iterator;
  typedef list<groupsearch_group>::reverse_iterator reverse_iterator;
  typedef list<groupsearch_group>::const_reverse_iterator
  const_reverse_iterator;

  groupsearch(const char *, const char *);

  iterator begin(void) { return groups.begin(); }
  const_iterator begin(void) const { return groups.begin(); }
  iterator end(void) { return groups.end(); }
  const_iterator end(void) const { return groups.end(); }

  reverse_iterator rbegin(void) { return groups.rbegin(); }
  const_reverse_iterator rbegin(void) const { return groups.rbegin(); }
  reverse_iterator rend(void) { return groups.rend(); }
  const_reverse_iterator rend(void) const { return groups.rend(); }

  bool empty(void) const { return groups.empty(); }
  unsigned int size(void) const { return groups.size(); }

private:
  list<groupsearch_group> groups;
};

#endif
