// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <fstream>
#include "groupsearch.h"

groupsearch::groupsearch(const char *hostname, const char *mask) {
  struct hostent *info;
  int port, sock;
  struct sockaddr_in addr;
    
  {
    const char *div=strchr(hostname, ':');
    if(div) {
      info=gethostbyname(string(hostname, 0, div-hostname).c_str());
      port=atoi(div+1);
    } else {
      info=gethostbyname(hostname);
      port=119;
    }
    if(!info) return;
  }
  
  addr.sin_family=AF_INET;
  addr.sin_addr=*(struct in_addr *)info->h_addr;
  addr.sin_port=htons(port);

  if((sock=socket(PF_INET, SOCK_STREAM, 0))<0) return;
  if(connect(sock, (struct sockaddr *)&addr, sizeof(addr))<0) return;

  char buf[1024];
  fstream server(sock);
  server.getline(buf, sizeof(buf));
  if(server.eof()||server.fail()||atoi(buf)!=200) {
    server.close();
    return;
  }
  server<<"LIST NEWSGROUPS "<<mask<<"\r\n";
  server.flush();
  server.getline(buf, sizeof(buf));
  if(server.eof()||server.fail()||atoi(buf)!=215) {
    server.close();
    return;
  }
  server.getline(buf, sizeof(buf));
  while(!(server.eof()||server.fail()||buf[0]=='.')) {
    const char *name=strtok(buf, "\t\r"),
      *description=strtok(0, "\t\r");
    if(!strcmp(description, "-x-")) description="";
    groups.push_back(groupsearch_group(name, description));
    server.getline(buf, sizeof(buf));
  }
  server<<"QUIT\r\n";
  server.flush();
  server.close();
}
