// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _COMPOSITION_H
#define _COMPOSITION_H

#include <string>
#include <vector>
#include <map>

#ifndef _LT_STRING
#define _LT_STRING

class lt_string {
public:
  bool operator()(const string& a, const string& b) const { return a<b; }
};

#endif

class composition_attachment {
public:
  enum encoding {PLAIN, BASE64};
  enum disposition {ATTACHMENT, INLINE};

  composition_attachment(void) { }
  composition_attachment(const char *f, const char *m, const char *n,
			 enum encoding e, enum disposition d) :
    filename(f), mime(m), name(n), how(e), where(d) { }
  bool extract(ostream&, const char * ="\n") const;
  enum encoding get_encoding(void) const { return how; }
  enum disposition get_disposition(void) const { return where; }

private:
  string filename, mime, name;
  enum encoding how;
  enum disposition where;
  static char basis_64[];
};

class composition {
public:
  void set_header(const char *name, const char *value) {
    if(*value) headers[name]=value;
  }
  const char *get_header(const char *name) const;
  void set_body(const char *text) { body=text; }
  const char *get_body(void) const { return body.c_str(); }
  void attach(const char *, const char *, const char *);
  void forward(const char *);
  bool sendmail(const char *) const;
  bool news(const char *) const;
  const composition_attachment& operator[](int x) const {
    return attachments[x];
  }
  int size(void) const { return attachments.size(); }
  void clear(void);

  void append(const char *what) { body+=what; }
  void append(istream&);
  void postpone(ostream& out) const {
    private_headers(out);
    extract_headers(out);
    extract_content(out);
  }
  void outbox(ostream& out) const;

private:
  map<string, string, lt_string> headers;
  string body;
  vector<composition_attachment> attachments;

  void private_headers(ostream&, const char * ="\n") const;
  void extract_content(ostream&, const char * ="\n") const;
  void extract_headers(ostream&, const char * ="\n") const;
  void extract(ostream&, const char * ="\n") const;
};

#endif
