#include "main.h"
#include "main.moc"

#include <klocale.h>
#include <kstdaction.h>

#include "settings.h"
#include "ai.h"
#include "inter.h"


KSettingWidget *MainWindow::createGameSettings()
{
    return new GameSettingsWidget;
}

KSettingWidget *MainWindow::createAppearanceSettings()
{
    return new AppearanceSettingsWidget;
}

KSettingWidget *MainWindow::createAISettings()
{
    AI *ai = Factory::self()->createAI();
    KSettingWidget *sw = ai->createSettingWidget();
    delete ai;
    return sw;
}

void MainWindow::init(const MPGameInfo &mp)
{
    Interface *inter = new Interface(mp, new KAccel(this), this);
    _inter = inter;
    inter->singleHuman();

	// Multiplayers
	(void)new KAction(i18n("Single Human"), 0, inter, SLOT(singleHuman()),
					  actionCollection(), "mp_single_human");
	(void)new KAction(i18n("Human vs Human"), 0, inter, SLOT(humanVsHuman()),
					  actionCollection(), "mp_human_vs_human");
	(void)new KAction(i18n("Human vs &Computer"), 0,
					  inter, SLOT(humanVsComputer()),
					  actionCollection(), "mp_human_vs_computer");
	(void)new KAction(i18n("More..."), 0, inter, SLOT(dialog()),
					  actionCollection(), "mp_more");

	// Settings
    KStdAction::keyBindings(inter, SLOT(configureKeys()), actionCollection());

    buildGUI(inter);
}
