#include "field.h"

#include <qwhatsthis.h>

#include <klocale.h>

#include "defines.h"
#include "board.h"
#include "settings.h"


BaseField::BaseField(QWidget *w)
    : widget(w), button(true), multiplayers(false)
{
	top = new QGridLayout(w, 3, 5, 10);

    lcds = new QGridLayout(7, 1, 5);
    top->addLayout(lcds, 1, 0);
    lcds->setRowStretch(1, 0);

    board = Factory::self()->createBoard(true, w);
    _boardRootPixmap = new KCanvasRootPixmap(board);
    _boardRootPixmap->start();
	top->addWidget(board, 1, 2);

// board layout
	QVBoxLayout *btop = new QVBoxLayout(board);
	btop->addStretch(3);

	msg = new QLabel(board);
	msg->setAlignment(Qt::AlignCenter);
	msg->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	btop->addWidget(msg, 0, Qt::AlignCenter);
	msg->hide();
	btop->addStretch(1);

	// #### the string is dummy : it seems necessary to have the "good" size !?
	pb = new QPushButton(" ", board);
	btop->addWidget(pb, 0, Qt::AlignCenter);
    pb->hide();
	btop->addStretch(3);
}

BaseField::~BaseField()
{}

void BaseField::init(bool AI, bool multi, bool server, bool first,
                     const QString &name)
{
    multiplayers = multi;
	QString msg = (AI ? i18n("%1\n(AI player)").arg(name)
		   : (multi ? i18n("%1\n(Human player)").arg(name) : QString::null));
	if ( first && !server ) msg += i18n("\nWaiting for server start");
	button = (first && server);
	midButton((button ? i18n("Press to Start") : QString::null), msg);
    showScore->resetColor();
}

void BaseField::midButton(const QString &pt, const QString &mt, bool start)
{
	if ( !mt.isNull() ) {
		msg->setText(mt);
		msg->show();
	} else msg->hide();

	if ( !pt.isNull() ) {
		pb->setText(pt);
		pb->show();
		pb->setFocus();
		if (start) widget->connect(pb, SIGNAL(clicked()),
                                   widget->parent(), SLOT(start()));
		else widget->connect(pb, SIGNAL(clicked()),
                             widget->parent(), SLOT(pause()));
	} else {
		pb->hide();
		pb->disconnect(SIGNAL(clicked()));
	}
}

void BaseField::init(const GTInitData &data)
{
    firstScore = KExtHighscores::firstScore();
    lastScore = KExtHighscores::lastScore();

	board->init(data);
    hideButton();
	board->start();
}

void BaseField::pause(bool pause)
{
	if (pause) {
		board->pause();
		midButton((button ? i18n("Press to Resume") : QString::null),
				  i18n("Game paused"), FALSE);
	} else {
		hideButton();
		board->unpause();
	}
}

void BaseField::stop(bool gameover)
{
	board->stop();
	if (gameover)
        midButton((button ? i18n("Press to Start") : QString::null),
                  i18n("Game over"));
}

void BaseField::scoreUpdated(int score)
{
    showScore->display(score);
    if (multiplayers) return;

    QColor color;
    if ( firstScore<currentScore() ) color = Qt::red;
    else if ( lastScore<currentScore() ) color = Qt::blue;
    showScore->setColor(color);
}

void BaseField::settingsChanged()
{
    board->settingsChanged();
    _boardRootPixmap
        ->setFadeEffect(AppearanceSettingsWidget::readFadeStrength(),
                        AppearanceSettingsWidget::readFadeColor());
    _boardRootPixmap->start();
}
