set rcsid {$Id: copyright.tcl,v 1.6 2007/03/10 20:50:18 drh Exp $}
source common.tcl
header {SQLite Copyright}
puts {
<h2>SQLite Copyright</h2>

<table align="right" vspace="0" hspace="10" border="1" cellpadding="20">
<tr><td align="center">
<img src="nocopy.gif"><br>
SQLite is in the<br>
<a href="http://en.wikipedia.org/wiki/Public_Domain">Public Domain</a>
</td></tr>
</table>

<p>
All of the deliverable code in SQLite has been dedicated to the
<a href="http://en.wikipedia.org/wiki/Public_Domain">public domain</a>
by the authors.
All code authors, and representatives of the companies they work for,
have signed affidavits dedicating their contributions to
the public domain and originals of
those signed affidavits are stored in a firesafe at the main offices
of <a href="http://www.hwaci.com">Hwaci</a>.
Anyone is free to copy, modify, publish, use, compile, sell, or distribute
the original SQLite code, either in source code form or as a compiled binary,
for any purpose, commercial or non-commercial, and by any means.
</p>

<p>
The previous paragraph applies to the deliverable code in SQLite - 
those parts of the SQLite library that you actually bundle and
ship with a larger application.  Portions of the documentation and
some code used as part of the build process might fall under
other licenses.  The details here are unclear.  We do not worry
about the licensing of the documentation and build code so much
because none of these things are part of the core deliverable
SQLite library.
</p>

<p>
All of the deliverable code in SQLite has been written from scratch.
No code has been taken from other projects or from the open
internet.  Every line of code can be traced back to its original
author, and all of those authors have public domain dedications
on file.  So the SQLite code base is clean and is
uncontaminated with licensed code from other projects.
</p>

<h2>Obtaining An Explicit License To Use SQLite</h2>

<p>
Even though SQLite is in the public domain and does not require
a license, some users want to obtain a license anyway.  Some reasons
for obtaining a license include:
</p>

<ul>
<li> You are using SQLite in a jurisdiction that does not recognize
     the public domain.  </li>
<li> You are using SQLite in a jurisdiction that does not recognize
     the right of an author to dedicate their work to the public
     domain. </li>
<li> You want to hold a tangible legal document
     as evidence that you have the legal right to use and distribute
     SQLite. </li>
<li> Your legal department tells you that you have to purchase a license.
     </li>
</ul>

<p>
If you feel like you really have to purchase a license for SQLite,
<a href="http://www.hwaci.com/">Hwaci</a>, the company that employs 
the architect and principal developers of SQLite, will sell you
one.
Please contact:
</p>

<blockquote>
D. Richard Hipp <br />
Hwaci - Applied Software Research <br />
704.948.4565 <br />
<a href="mailto:drh@hwaci.com">drh@hwaci.com</a>
</blockquote>

<h2>Contributed Code</h2>

<p>
In order to keep SQLite completely free and unencumbered by copyright,
all new contributors to the SQLite code base are asked to dedicate
their contributions to the public domain.
If you want to send a patch or enhancement for possible inclusion in the
SQLite source tree, please accompany the patch with the following statement:
</p>

<blockquote><i>
The author or authors of this code dedicate any and all copyright interest
in this code to the public domain.  We make this dedication for the benefit
of the public at large and to the detriment of our heirs and successors.
We intend this dedication to be an overt act of relinquishment in
perpetuity of all present and future rights this code under copyright law.
</i></blockquote>

<p>
We are not able to accept patches or changes to 
SQLite that are not accompanied by a statement such as the above.
In addition, if you make
changes or enhancements as an employee, then a simple statement such as the
above is insufficient.  You must also send by surface mail a copyright release
signed by a company officer.
A signed original of the copyright release should be mailed to:</p>

<blockquote>
Hwaci<br>
6200 Maple Cove Lane<br>
Charlotte, NC 28269<br>
USA
</blockquote>

<p>
A template copyright release is available
in <a href="copyright-release.pdf">PDF</a> or
<a href="copyright-release.html">HTML</a>.
You can use this release to make future changes. 
</p>
}
footer $rcsid
