/* Nessus Attack Scripting Language
 *
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <includes.h>
#ifndef MAP_FAILED
#define MAP_FAILED ((void*)-1)
#endif
#include "execute.h"
#include "defines.h"
#include "init.h"
#include "pkt_utils.h"
#include "parser.h"
#include "function_call.h"
#include "nasl_memory.h"

extern int execute_instruction(harglst *, char *);

int
execute_script(globals, name)
 harglst * globals;
 char * name;
{
 int fd = open(name, O_RDONLY);
 char * command;
 char * buffer;
 struct stat sb;
 int len;
 int err;
 if(fd < 0){
  perror("open ");
  return(-1);
  }
 fstat(fd, &sb);
 len = sb.st_size;
 command = mmap(NULL, len, PROT_READ, MAP_PRIVATE, fd, 0);
 if(command == MAP_FAILED)
 {
  perror("mmap ");
  return(-1);
 }
 buffer = nasl_strdup(globals,command);
 munmap(command, len);
 close(fd);
 err = execute_script_buffer(globals, buffer);
 nasl_free(globals, buffer);
 return(err);
}

int execute_script_buffer(globals, buffer)
 harglst * globals;
 char * buffer;
{
  char * r = NULL;
  char * inst;
  char * buf = buffer; 
  int err = 0;
  while((inst = read_buf_instruction(globals, buf, &r)))
  {
   char * t = (char*)remove_whitespaces(globals, inst);
   if(!t)return PKT_ERROR(ERR_PARSE);
   nasl_free(globals, inst);
   err = execute_instruction(globals, t);
   if(err<0)break;
   buf = r;
  }
 return(err);
}
