<?php

include_once 'Horde/SyncML/State.php';

/**
 * The Horde_SyncML_Command class provides a super class fo SyncBody commands.
 *
 * $Horde: framework/SyncML/SyncML/Command.php,v 1.4.10.4 2005/07/07 18:22:47 selsky Exp $
 *
 * Copyright 2003-2005 Anthony Mills <amills@pyramid6.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Anthony Mills <amills@pyramid6.com>
 * @since   Horde 3.0
 * @package Horde_SyncML
 */
class Horde_SyncML_Command {

    /**
     * @var integer
     */
    var $_cmdID;

    /**
     * Internal structure used during XML parsing.
     *
     * @var array
     */
    var $_Stack = array();

    /**
     * @var string
     */
    var $_chars;

    function &factory($command, $params = null)
    {
        include_once 'Horde/SyncML/Command/' . $command . '.php';
        $class = 'Horde_SyncML_Command_' . $command;
        if (class_exists($class)) {
            return $cmd = &new $class($params);
        } else {
            $GLOBALS['backend']->logMessage('Class definition of ' . $class . ' not found.',
                                            __FILE__, __LINE__, PEAR_LOG_ERR);
            include_once 'PEAR.php';
            return PEAR::raiseError('Class definition of ' . $class . ' not found.');
        }
    }

    function output($currentCmdID, $output)
    {
    }

    function startElement($uri, $localName, $attrs)
    {
        $this->_Stack[] = $localName;
    }

    function endElement($uri, $element)
    {
        switch (count($this->_Stack)) {
        case 2:
            if ($element == 'CmdID') {
                $this->_cmdID = intval(trim($this->_chars));
            }
            break;
        }

        $this->_chars = '';
        array_pop($this->_Stack);
    }

    function characters($str)
    {
        $this->_chars .= $str;
    }

}
