#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "WFTP login check";
 name["francais"] = "Vrification de login de WFTP";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "This FTP server accepts
any login/password combination. This is a real
threat, since anyone can browse the FTP section
of your disk without your consent.

Solution : upgrade WFTP.

Risk factor : High";
 


 desc["francais"] = "Ce serveur FTP accepte
n'importe quelle paire login/password. 
C'est un vrai problme puisque n'importe
qui peut fouiner la section FTP de votre
disque dur, sans votre accord.

Solution : mettez  jour WFTP.

Facteur de risque : Elev";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for any account";
 summary["francais"] = "Vrifie n'importe quel accompte";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "FTP";
 family["francais"] = "FTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/ftp");
if(!port)port = 21;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  if(ftp_log_in(socket:soc, user:"bogusbogus", pass:"soogjksjka"))
  {
   security_hole(port);
   set_kb_item(name:"ftp/wftp_login_problem", value:TRUE);
  }
  close(soc);
 }
}
