#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Microsoft Frontpage exploits";
 name["francais"] = "Exploits Microsoft Frontpage"; 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote web server appears to be running with
Frontpage extensions and lets the file 'authors.pwd'
to be downloaded by everyone.

This is a security concern since this file contains
sensitive data.

Solution : Contact Microsoft for a fix.

Risk factor : Medium";

 desc["francais"] = "
Le serveur web distant semble tourner avec
des extensions Frontpage et laisse le fichiers
'authors.pwd' en libre accs.

C'est un problme puisque ce fichier contient
des informations sensibles.

Solution : Contactez Microsoft pour un patch.

Facteur de risque : Moyen";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of Microsoft Frontpage extensions";
 summary["francais"] = "Vrifie la prsence des extensions Frontpage";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port) port = 80;
if(is_cgi_installed("/_vti_pvt/authors.pwd"))
{
 security_hole(port);
}
