<?php
/**
 * $Horde: turba/edit.php,v 1.70.4.1 2005/01/03 12:25:47 jan Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once 'Horde/Form.php';
require_once 'Horde/Variables.php';

$renderer = &new Turba_Renderer();
$vars = &Variables::getDefaultVariables();

$url = $vars->get('url');
$source = $vars->get('source');
if ($source === null || !isset($cfgSources[$source])) {
    $notification->push(_("The contact you requested does not exist."));
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$driver = &Turba_Driver::singleton($source, $cfgSources[$source]);

/* Set the contact from the key requested. */
$key = $vars->get('key');
$object = $driver->getObject($key);
if (is_a($object, 'PEAR_Error')) {
    $notification->push($object->getMessage(), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

/* Check permissions on this contact. */
$editdone = false;
if (!Turba::hasPermission($object, 'object', PERMS_EDIT)) {
    if (!Turba::hasPermission($object, 'object', PERMS_READ)) {
        $notification->push(_("You do not have permission to view this contact."), 'horde.error');
        header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
        exit;
    } else {
        $notification->push(_("You only have permission to view this contact."), 'horde.error');
        $editdone = true;
    }
}

$title = sprintf(_("Edit entry for %s"), $object->getValue('name'));

/* Get the form object. */
$form = &Horde_Form::singleton('', $vars, $title);
$form->setButtons(_("Save"), _("Undo Changes"));
$form->addHidden('', 'url', 'text', false);
$form->addHidden('', 'source', 'text', true);
$form->addHidden('', 'key', 'text', false);

$renderer->setObject($object);
$view = &new Turba_ObjectView($object);
$view->setupForm($form);

if ($form->validate($vars)) {
    /* Form valid, save data. */
    $form->getInfo($vars, $info);

    /* Update Contact. */
    foreach ($info['object'] as $info_key => $info_val) {
        if ($info_key != '__key') {
            $object->setValue($info_key, $info_val);
        }
    }
    $success = $object->store();
    $key = $object->getValue('__key');
    if (!is_a($success, 'PEAR_Error')) {
        $notification->push(sprintf(_("Entry for %s updated."), $object->getValue('name')), 'horde.success');
        $form->setTitle(sprintf(_("Edit entry for %s"), $object->getValue('name')));
        $editdone = true;
    } else {
        Horde::logMessage($key, __FILE__, __LINE__, PEAR_LOG_ERR);
        $notification->push(sprintf(_("There was an error updating this entry: %s"), $success->getMessage()), 'horde.error');
    }
} else {
    $object_values = $vars->get('object');
    foreach ($object->attributes as $info_key => $info_val) {
        if (!isset($object_values[$info_key])) {
            $object_values[$info_key] = $info_val;
        }
    }
    $vars->set('object', $object_values);
    $vars->set('url', $url);
    $vars->set('source', $source);
    $vars->set('key', $key);
}

if ($editdone) {
    if (empty($info['url'])) {
        $uri = Util::addParameter('display.php', array('source' => $info['source'], 'key' => $key));
        $uri = Horde::applicationUrl($uri, true);
    } else {
        $uri = $info['url'];
    }

    header('Location: ' . $uri);
    exit;
}

$notification->push('var i = 0; while (document.forms[0].elements[i].type == \'hidden\') i++; document.forms[0].elements[i].focus();', 'javascript');
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/menu.inc';
$form->renderActive($renderer, $vars, 'edit.php', 'post');
require $registry->get('templates', 'horde') . '/common-footer.inc';
