/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: platforms.h,v 1.4 2004/05/10 01:59:40 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _PLATFORMS_HH
#define _PLATFORMS_HH

#include "config.h"

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>

namespace libfwbuilder {
    class FWOptions;
    class Firewall;
};

bool isUsingNetZone(libfwbuilder::Firewall *fw);

bool isDefaultOptions(libfwbuilder::FWOptions *opt);

QMap<QString,QString> getVersionsForPlatform(const QString &platform);

/**
 * returns a list of log levels that can be used to populate qcombobox
 * widget.  I do not see how log levels can be different for various
 * fw platforms, but who knows.
 */
QStringList getLogLevels(const QString &platform);

/**
 * like the above, except returns a list of log facilities.
 */
QStringList getLogFacilities(const QString &platform);

#endif

