/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: LibraryDialog.cpp,v 1.26 2004/12/18 03:03:31 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "LibraryDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcolordialog.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qpainter.h>

using namespace std;
using namespace libfwbuilder;

LibraryDialog::LibraryDialog(QWidget *parent) : LibraryDialog_q(parent)
{
    obj=NULL;

    WFlags flags = getWFlags();
    flags &= ~Qt::WStyle_Maximize;
    flags &= ~Qt::WStyle_Minimize;
    setWFlags(flags);
}

void LibraryDialog::loadFWObject(FWObject *o)
{
    obj=o;
    Library *s = dynamic_cast<Library*>(obj);
    assert(s!=NULL);

    init=true;
    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    obj_name->setEnabled( obj->getId() != "syslib000" );
//    apply->setEnabled( obj->getId() != "syslib000" );
//    comment->setEnabled(  !FWBTree::isSystem(obj) );

    color=obj->getStr("color").c_str();
    if (color=="") color="#FFFFFF";   // white is the default

    fillColor();

    apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    colorButton->setEnabled(!o->isReadOnly());
    setDisabledPalette(colorButton);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void LibraryDialog::changed()
{
    apply->setEnabled( true );
}

void LibraryDialog::changeIds(FWObject *root)
{
    if (FWBTree::isStandardId(root))
        root->setId(FWObjectDatabase::db->generateUniqueId());
        
    for (FWObject::iterator i=root->begin(); i!=root->end(); i++)
        changeIds( *i );
}

void LibraryDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    string oldname=obj->getName();
    QString oldcolor=obj->getStr("color").c_str();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );
    obj->setStr("color", color.latin1());

/* just for fool-proof'ness, do not allow changing name of the 'Standard' lib */
    if (oldname!=obj->getName() && obj->getId()=="syslib000")
    {
        obj->setName( oldname );
    }

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));
    om->updateLibName(obj);
    if (color!=oldcolor) om->updateLibColor(obj);

    apply->setEnabled( false );
}

void LibraryDialog::discardChanges()
{
    loadFWObject(obj);
}

void LibraryDialog::validate(bool *res)
{
    *res=true;
}

void LibraryDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void LibraryDialog::changeColor()
{
    if (!isTreeReadWrite(this,obj)) return;

    QColor clr = QColorDialog::getColor(
        QColor(color), this, tr("Pick the color for this library") );
    if (!clr.isValid()) return;

    color = clr.name();
    fillColor();

    changed();
}

void LibraryDialog::fillColor()
{
    QPixmap pm(40,14);
    pm.fill( QColor(color) );
    QPainter p( &pm );
    p.drawRect( pm.rect() );
    colorButton->setPixmap(pm);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void LibraryDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

