/* $Id: gii_debug.h,v 1.3 1998/11/19 00:59:00 marcus Exp $
******************************************************************************

   LibGII debugging macros

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_INTERNAL_GII_DEBUG_H
#define _GGI_INTERNAL_GII_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/system.h>
#include <ggi/gg.h>

extern uint32 _giiDebugState;
extern int _giiDebugSync;

/* Debugging types
 * bit 0 is reserved! */

#define GIIDEBUG_CORE		(1<<1)	/*   2 */
#define GIIDEBUG_MISC		(1<<5)	/*  32 */
#define GIIDEBUG_LIBS		(1<<6)	/*  64 */
#define GIIDEBUG_EVENTS		(1<<7)	/* 128 */

#define GIIDEBUG_ALL	0xffffffff

#ifndef DPRINT_CORE
#ifndef __GNUC__
extern void DPRINT(const char *format,...);
#define DPRINT_CORE	DPRINT
#define DPRINT_MODE	DPRINT
#define DPRINT_COLOR	DPRINT
#define DPRINT_DRAW	DPRINT
#define DPRINT_MISC	DPRINT
#define DPRINT_LIBS	DPRINT
#define DPRINT_EVENTS	DPRINT

#else /* !__GNUC__ */

#ifdef DEBUG
#define DPRINT(form,args...)	    if (_giiDebugState) { ggDPrintf(_giiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_CORE(form,args...)   if (_giiDebugState & GIIDEBUG_CORE) { ggDPrintf(_giiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_MISC(form,args...)   if (_giiDebugState & GIIDEBUG_MISC) { ggDPrintf(_giiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_LIBS(form,args...)   if (_giiDebugState & GIIDEBUG_LIBS) { ggDPrintf(_giiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_EVENTS(form,args...) if (_giiDebugState & GIIDEBUG_EVENTS) { ggDPrintf(_giiDebugSync,__FILE__,__LINE__,form, ##args); }
#else /* DEBUG */
#define DPRINT(form,args...)		do { } while (0)
#define DPRINT_CORE(form,args...)	do { } while (0)
#define DPRINT_MODE(form,args...)	do { } while (0)
#define DPRINT_COLOR(form,args...)	do { } while (0)
#define DPRINT_DRAW(form,args...)	do { } while (0)
#define DPRINT_MISC(form,args...)	do { } while (0)
#define DPRINT_LIBS(form,args...)	do { } while (0)
#define DPRINT_EVENTS(form,args...)	do { } while (0)
#endif /* DEBUG */
#endif /* !__GNUC__ */
#define DPRINT_ALL			DPRINT
#endif /* DPRINT_CORE */

#ifdef DEBUG
#define LIBGII_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGII:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define LIBGII_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGII:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else 
#define LIBGII_ASSERT(x,str)	do { } while (0)
#define LIBGII_APPASSERT(x,str)	do { } while (0)
#endif /* DEBUG */

#endif /* _GGI_INTERNAL_GII_DEBUG_H */
