/*
 * GQmpeg
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqmpeg.h"
#include "russian_tag.h"

#ifdef ENABLE_RUSSIAN_TAGS

#ifndef ENCODE_TABLE
#define ENCODE_TABLE 2
#endif

static unsigned char recode_table[5][128] = {
	{ /* koi8 */
	    128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
	    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
	    160,161,162,163,164,165,166,167,168,169,170,171,172,'-',174,175,
	    176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
	    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
	    208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
	    224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
	    240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
	{ /* dos - cp866 */
	    225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	    242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	    193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	    128,129,130,131,132,133,134,135,136,137,186,139,140,141,142,143,
	    144,145,146,147,148,149,150,151,152,153,154,191,156,157,158,159,
	    160,161,162,176,164,165,166,167,168,169,170,171,172,173,174,175,
	    210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
	    179,163,'+','+','+','+','+','+',184,'+','+','+','+','+',190,' ' },
	{ /* win - cp1251 */
	    '+','+', 39,'+', 34,'+','+','+','+','+','+', 39,'+','+','+','+',
	    '+', 39, 39, 34, 34,'+','+','-','-','*','+', 39,'+','+','+','+',
	    ' ','+','I','+','+','+','+','+',179,188,'E', 34,'+','+','*','I',
	    184,'+','i',199,'*','*','*','*',163,'N','e', 34,'j','S','s','i',
	    225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	    242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	    193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	    210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209 },
	{ /* iso 9886-5 */
	    '+','+','+','+','+','+','+','+','+','+','+','+','+','+','+','+',
	    '+','+','+','+','+','+','+','+','+','+','+','+','+','+','+','+',
	    '*',179,'*','*','*','*','*','*','*','*','*','*','*','*','*','*',
	    225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	    242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	    193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	    210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
	    '*',163,'*','*','*','*','*','*','*','*','*','*','*','*','*','*' },
	{ /* mac Cyrillic */
	    225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	    242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	    '*',184,'*','*','*','*','*','I','*','*','*','*','*','*','*','*',
	    '*',179,177,178,'i','*',199,'J','E','e','I','i','*','*','*','*',
	    'j','S','*','*','f','*','*','*','*','*','*','*','*','*','*','s',
	    '-','-', 34, 34, 39, 39,'*', 39,'*','*','*','*','N',163,179,209,
	    193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	    210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,'*' }
};


void russian_recode(unsigned char *message, long number)
{
	long i;
	char tmp;
	for(i = 0; i < number; i++)
		{
		tmp = message[i];
		if (tmp & 0x80 )
			{
			gint tab;

			tab = ENCODE_TABLE < 5 ? ENCODE_TABLE : 2;
			tmp = recode_table[tab][tmp & 0x7F];
			}
		message[i] = tmp;
		}
}

#endif
