#ifndef MAINWINDOW_H 
#define MAINWINDOW_H

#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qtextedit.h>
#include <qintdict.h>
#include <qcanvas.h>
#include <qlineedit.h>
#include <qaction.h>
#include <qcursor.h>
#include <qtabwidget.h>
#include <qmap.h>

#include "file.h"
#include "findwindow.h"
#include "mapeditor.h"
#include "texteditor.h"
#include "xml.h"

class Main : public QMainWindow 
{
    Q_OBJECT

public:
    Main(QWidget* parent=0, const char* name=0, WFlags f=0);
    ~Main();
	void loadCmdLine();
	void statusMessage (const QString &);

public slots:
    void fileNew();

protected:
	void closeEvent( QCloseEvent* );

private:
    void setupFileActions();
    void setupEditActions();
    void setupFormatActions();
    void setupViewActions();
    void setupModeActions();
    void setupWindowActions();
    void setupFlagActions();
    void setupSettingsActions();
    void setupTestActions();
    void setupHelpActions();
    void setupContextMenus();
	void setupLastMapsMenu();
	void hideEvent (QHideEvent * );
	void showEvent (QShowEvent * );
	bool reallyWriteDirectory(const QString&);
	QString browseDirectory(const QString&);
	MapEditor* currentMapEditor() const;
    
private slots:
    void newView();
	void editorChanged(QWidget*);

    ErrorCode fileLoad(QString ,const LoadMode &);
    void fileLoad(const LoadMode &);
    void fileLoad();
	void fileLoadLast(int);
    void fileSave(const SaveMode & );
    void fileSave();
    void fileSaveAs(const SaveMode &);
    void fileSaveAs();
    void fileImportKDEBookmarks();
    void fileImportFirefoxBookmarks();
    void fileImportMM();
    void fileImportDir();
    void fileExportXML();
    void fileExportXHTML();
    void fileExportImage(int);
    void fileExportASCII();
    void fileExportLaTeX();
    void fileExportKDEBookmarks();
    void fileExportTaskjuggler();
    void fileExportOOPresentation();
    void fileCloseMap();
    void filePrint();
    void fileExitVYM();

    void editUndo();	
    void editRedo();	
    void editCopy();	
    void editPaste();	
    void editCut();	
    void editOpenFindWindow();
	void editFind(QString);
	void editFindChanged();
public slots:
	void editOpenURL();
	void editOpenURLTab();
private slots:
	void editURL();
	void editHeading2URL();
	void editBugzilla2URL();
	void editFATE2URL();
	void editVymLink();
public slots:
	void editOpenVymLink();
private slots:
	void editDeleteVymLink();
	void editToggleHideExport();
	void editMapInfo();
    void editMoveUp();	
    void editMoveDown();	
    void editToggleScroll();
    void editUnScrollAll();
    void editHeading();
    void editNewBranch();
    void editNewBranchHere();
    void editNewBranchAbove();
    void editNewBranchBelow();
    void editImportAdd();
    void editImportReplace();
    void editSaveBranch();
    void editRemoveBranchKeepChilds();
    void editRemoveChilds();
    void editDeleteSelection();
    void editUpperBranch();
    void editLowerBranch();
    void editLeftBranch();
    void editRightBranch();
    void editFirstBranch();
    void editLastBranch();
    void editLoadImage();
    void editSaveImage(int);
    void editFollowXLink (int);
    void editEditXLink (int);

    void formatSelectColor();
    void formatPickColor();
    void colorChanged(QColor);
    void formatColorItem();
    void formatColorBranch();
	void formatLinkStyleLine();
	void formatLinkStyleParabel();
	void formatLinkStylePolyLine();
	void formatLinkStylePolyParabel();
    void formatSelectBackColor();
    void formatSelectLinkColor();
    void formatToggleLinkColorHint();
	void formatFrameNone();
	void formatFrameRectangle();
	void formatIncludeImagesVer();
	void formatIncludeImagesHor();
	void formatHideLinkUnselected();

    void viewZoomReset();
    void viewZoomIn();
    void viewZoomOut();

	void modModeColor();
	void modModeLink();

public slots:
	bool settingsPDF();
	bool settingsURL();
	void settingsToggleDelKey();

	void windowToggleNoteEditor();
	void windowToggleHistory();
	void updateNoteFlag();

private slots:
	void windowNextEditor();
	void windowPreviousEditor();
	void windowShowNoteEditor();
	void windowHideNoteEditor();

	void standardFlagChanged();

    void testFunction();

    void helpDoc();
    void helpAbout();
    void helpAboutQT();

private:
// not needed?    QCanvas* canvas;
	QTabWidget *tabWidget;
	FindWindow *findWindow;
	QStringList lastMaps;
	int maxLastMaps;
	QString lastFileDir;
	QProcess *procBrowser;
};


#endif

