#include <qapplication.h>
#include <qpixmap.h>
#include <qtranslator.h>
#include <qdir.h>
#include <qptrlist.h>
#include <qtextcodec.h>
#include <qnetwork.h>
#include <qmime.h>

#include "settings.h"
#include "options.h"
#include "mainwindow.h"

#include "flagrowobj.h"

// Global variables
TextEditor *textEditor;			// used in Constr. of LinkableMapObj
								// initialized in mainwindow

Main *mainWindow;				// used in BranchObj::select()								
QString tmpVymDir;				// All temp files go there, created in mainwindow
QString clipboardDir;			// Clipboard used in all mapEditors
QDir vymBaseDir;				// Containing all styles, scripts, images, ...
QString iconPath;				// Pointing to icons used for toolbars
QString flagsPath;				// Pointing to flags
bool clipboardEmpty;			
FlagRowObj *systemFlagsDefault;	// used to copy from in LinkableMapObj
FlagRowObj *standardFlagsDefault;

// Lists of actions
// (QActionGroup could not be "enabled")
QPtrList <QAction> actionListBranches;

// Actions which change sometimes
QAction *actionFileSave;
QAction *actionFilePrint;
QAction *actionEditUndo;
QAction *actionEditRedo;
QAction *actionEditCopy;
QAction *actionEditCut;
QAction *actionEditPaste;
QAction *actionEditMoveUp;
QAction *actionEditMoveDown;
QAction *actionEditToggleScroll;
QAction *actionEditOpenURL;
QAction *actionEditOpenURLTab;
QAction *actionEditURL;
QAction *actionEditHeading2URL;
QAction *actionEditBugzilla2URL;
QAction *actionEditFATE2URL;
QAction *actionEditOpenVymLink;
QAction *actionEditVymLink;
QAction *actionEditToggleHideExport;
QAction *actionEditDeleteVymLink;
QAction *actionEditMapInfo;
QAction *actionEditHeading;
QAction *actionEditDelete;
QAction *actionEditAddBranch;
QAction *actionEditAddBranchHere;
QAction *actionEditAddBranchAbove;
QAction *actionEditAddBranchBelow;
QAction *actionEditRemoveBranchKeepChilds;
QAction *actionEditRemoveChilds;
QAction *actionEditImportAdd;
QAction *actionEditImportReplace;
QAction *actionEditSaveBranch;
QAction *actionEditSelectFirst;
QAction *actionEditSelectLast;
QAction *actionEditLoadImage;

QAction *actionFormatColor;		
QAction *actionFormatPickColor;		
QAction *actionFormatColorBranch;
QAction *actionFormatColorSubtree;
QAction *actionFormatBackColor;
QAction *actionFormatLinkColorHint;
QAction *actionFormatLinkColor;		

QActionGroup *actionGroupModModes;
QAction *actionModModeColor;
QAction *actionModModeLink;
QAction *actionModModeCopy;

QActionGroup *actionGroupFormatFrameTypes;
QAction *actionFormatFrameNone;
QAction *actionFormatFrameRectangle;

QActionGroup *actionGroupFormatLinkStyles;
QAction *actionFormatIncludeImagesVer;
QAction *actionFormatIncludeImagesHor;
QAction *actionFormatHideLinkUnselected;
QAction *actionFormatLinkStyleLine;
QAction *actionFormatLinkStyleParabel;
QAction *actionFormatLinkStylePolyLine;
QAction *actionFormatLinkStylePolyParabel;

QAction *actionViewToggleNoteEditor;
QAction *actionViewToggleHistoryWindow;

QAction *actionSettingsAutoselectHeading;
QAction *actionSettingsAutoselectText;
QAction *actionSettingsPasteNewHeading;
QAction *actionSettingsAutoedit;
QAction *actionSettingsUseDelKey;
QAction *actionSettingsUseFlagGroups;
QAction *actionSettingsUseHideExport;

QPopupMenu *branchContextMenu;
QPopupMenu *branchAddContextMenu;
QPopupMenu *branchRemoveContextMenu;
QPopupMenu *branchLinksContextMenu;
QPopupMenu *branchLinksContextMenuDup;
QPopupMenu *floatimageContextMenu;
QPopupMenu *saveImageFormatMenu;
QPopupMenu *canvasContextMenu;
QPopupMenu *lastMapsMenu;
QPopupMenu *importMenu;
QPopupMenu *exportMenu;
QPopupMenu *exportImageFormatMenu;


Settings settings;
Options options;

int statusbarTime=3500;

int main(int argc, char** argv)
{
    QApplication app(argc,argv);


	// Reading and initializing options commandline options
	options.add ("version", SwitchOption, "v","version");
	options.add ("local", SwitchOption, "l", "local");
	options.add ("help", SwitchOption, "h", "help");
	options.add ("quit", SwitchOption, "q", "quit");
	options.add ("test", StringOption, "t", "test");
	options.setHelpText (
		"VYM - View Your Mind\n"
		"--------------------\n\n"
		"Information about vym can be found in vym.pdf,\n"
		"which should be part of the vym package.\n"
		"It is also available at the project homepage:\n\n"
		"http://www.InSilmaril.de/vym\n");
	if (options.parse())
	{
		cout << endl << options.getHelpText()<<endl;
		return 1;
	}

	if (options.isOn ("version"))
	{
		cout << "vym version "<<__VYM_VERSION
			<<"  (c) 2004 Uwe Drechsel - "
			<<__BUILD_DATE<<endl;
			
		return 0;	
	}		
	
	// Use /usr/share/vym or /usr/local/share/vym or . ?
	// First try options
	if (options.isOn ("local"))
	{
		vymBaseDir.setPath (vymBaseDir.currentDirPath());
	} else
	// then look for environment variable
	if (getenv("VYMHOME")!=0)
	{
		vymBaseDir.setPath (getenv("VYMHOME"));
	} else
	// ok, let's find my way on my own
	{
		vymBaseDir.setPath ("/usr/share/vym");
		if (!vymBaseDir.exists())
		{
			vymBaseDir.setPath ("/usr/local/share/vym");
			if (!vymBaseDir.exists())
				vymBaseDir.setPath(vymBaseDir.currentDirPath() );
		}		
	}

	iconPath=vymBaseDir.path()+"/icons/";
	flagsPath=vymBaseDir.path()+"/flags/";

	if (options.isOn ("help"))
	{
		cout << options.getHelpText()<<endl;
		return 0;	
	}	

	if (options.isOn ("test"))
	{
		// FIXME testing string option only
		cout << "Testing: "<<options.getArg("test")<< endl;
	}	


    QMimeSourceFactory *factory = QMimeSourceFactory::defaultFactory();
    factory->setPixmap("vym-128x128", QPixmap(iconPath+"vym-128x128.png"));
    qInitNetworkProtocols();


	// Initialize translations
	QTranslator translator (0);
	translator.load( QString("vym_")+QTextCodec::locale(), vymBaseDir.path() + "/lang");
    app.installTranslator( &translator );

	// Initializing the row of system flags
	// is done in first call to MapEditor(),
	// because we need at least one canvas first
	systemFlagsDefault=NULL;
	standardFlagsDefault=NULL;

	// Initialize window of TextEditor
	textEditor = new TextEditor();
	textEditor->setIcon (QPixmap (iconPath+"vym-editor.png"));
	if (textEditor->showWithMain()) textEditor->show();

	// Initialize mainwindow 
    Main m;
	//m.resize(m.sizeHint());
	m.setIcon (QPixmap (iconPath+"vym-48x48.png"));
	m.show();
	m.fileNew();
	m.loadCmdLine();

	// For benchmarking we may want to quit immediatly after drawing
	if (options.isOn ("quit"))
	{
		return 0;
	}	

    QObject::connect( &app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()) );

    return app.exec();
}

