#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10308);
 
 name["english"] = "Detect Windows compatible ports";
 script_name(english:name["english"]);
 
 desc["english"] = "Windows compatible operating systems (such as MS-Windows, or UNIX Samba
Servers) have the following ports in a listening state:
TCP:135, TCP:139, UDP:137 and UDP:138.
If any of these ports is left open to the outside, the Windows operating
system is at risk of attack.

Solution: Block those ports from outside communication

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Detect Windows compatible ports";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_require_ports(135,139);
 
 exit(0);
}

#
# The script code starts here
#

if ((get_port_state(135)) && (get_port_state(139))
{
 soctcp135 = open_sock_tcp(135);
 soctcp139 = open_sock_tcp(139);
 socudp137 = open_sock_udp(137);
 socudp138 = open_sock_udp(138);

 if ((soctcp135) && (socudp137) && (socudp138) && (soctcp139))
 {
  if (socudp137)
  {
   send(socket:socudp137, data:"\r\n");
   result = recv(socket:socudp137, length:1000);
   if (!result)
   {
    send(socket:socudp138, data:"\r\n");
    result = recv(socket:socudp138, length:1000);
    if (!result)
    {
     set_kb_item(name:"Windows compatible", value:TRUE);
     security_hole(0);
    }
   }
 }

 close(soctcp135);
 close(socudp137);
 close(socudp138);
 close(soctcp139);
}
}
