#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# Changes by rd :
#  - use of function to simplify code
#
# See the Nessus Scripts License for details
#

if(description)
{
 
 script_id(10373);
 name["english"] = "TalentSoft Web+ version detection";
 script_name(english:name["english"]);
 
 desc["english"] = "Detect the version of Web+ CGI. The Web+ CGI has a known exploit
 that enables a remote attacker to gain access to local files.
 This bug is known to exist in Web+ 4.X as of March 1999, and probably exists in all previous versions as well.

 This test in itself does not verify the vulnerability but rather gains knowledge of the version of which Web+ currently running.

 Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Get the version of Web+ CGI";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2000 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
  script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


function extract_version(result, port)
{
    resultrecv = strstr(result, "Version: </b>: ");
    resultsub = strstr(resultrecv, string("\n"));
    resultrecv = resultrecv - resultsub;
    resultrecv = resultrecv - "Version: </b>: ";
    resultrecv = resultrecv - "\n";

    banner = "Web+ Version: " + resultrecv;
    banner = banner + "\n";

    resultrecv = strstr(result, "<br><b>Web+ Server Compile Number</b>: ");
    resultsub = strstr(resultrecv, string("\n"));
    resultrecv = resultrecv - resultsub;
    resultrecv = resultrecv - "<br><b>Web+ Server Compile Number</b>: ";
    resultrecv = resultrecv - "\n";

    banner = banner + "Web+ Server Compile Number: ";
    banner = banner + resultrecv;
    banner = banner + "\n";

    resultrecv = strstr(result, "<br><b>Web+ Client Compile Number</b>: ");
    resultsub = strstr(resultrecv, string("\n"));
    resultrecv = resultrecv - resultsub;
    resultrecv = resultrecv - "<br><b>Web+ Client Compile Number</b>: ";
    resultrecv = resultrecv - "\n";

    banner = banner + "Web+ Client Compile Number: ";
    banner = banner + resultrecv;
    banner = banner + "\n";

    resultrecv = strstr(result, "<br><b>Operating System</b>: ");
    resultsub = strstr(resultrecv, string("\n"));
    resultrecv = resultrecv - resultsub;
    resultrecv = resultrecv - "<br><b>Operating System</b>: ";
    resultrecv = resultrecv - "\n";

    banner = banner + "Operating System: ";
    banner = banner + resultrecv;
    banner = banner + "\n";

    security_warning(port:port, data:banner);
    return(0);
}

port = get_kb_item("Services/www");
if(!port)port = 80;

if(get_port_state(port))
{
  req1 = string("GET /cgi-bin/webplus?about HTTP/1.0\r\n\r\n");
  req2 = string("GET /cgi-bin/webplus.exe?about HTTP/1.0\r\n\r\n");
  soc = open_sock_tcp(port);
  if(soc)
  {
   send(socket:soc, data:req1);
   result = recv(socket:soc, length:4096);
   close(soc);
   if("TalentSoft Web+&#153 Product Information" >< result)
   {
    extract_result(result:result, port:port);
    exit(0);
   }
  }
 
  soc = open_sock_tcp(port);
  if(soc)
  {
   send(socket:soc, data:req2);
   result = recv(socket:soc, length:4096);
   close(soc);
   if("TalentSoft Web+&#153 Product Information" >< result)
   {
    extract_result(result:result, port:port);
    exit(0);
   }
  }
}

