#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10282);
 script_cve_id("CVE-1999-0070");
 
 name["english"] = "test-cgi";
 name["francais"] = "test-cgi";
 name["portugues"] = "test-cgi";
 script_name(english:name["english"], francais:name["francais"], portugues:name["portugues"]);
 
 desc["english"] = "The 'test-cgi' cgi is installed. This CGI has
a well known security flaw that lets anyone read arbitrary
files with the privileges of the http daemon (root or nobody).

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'test-cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
lire des fichiers arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 desc["portugues"] = "O cgi 'test-cgi' est instalado. Este CGI tem
uma falha de segurana bem conhecida que permite a qualquer um ler
arquivos arbitrrios com o privilgio do daemon http (root ou nobody).

Soluo : Remov-lo do /cgi-bin.

Fator de risco : Srio";


 script_description(english:desc["english"], francais:desc["francais"],
 		portugues:desc["portugues"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/test-cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/test-cgi";
 summary["portugues"] = "Verifica a presena de /cgi-bin/test-cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"],
 		portugues:summary["portugues"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison",
		portugues:"Este script  Copyright (C) 1999 Renaud Deraison");

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 family["portugues"] = "Abusos de CGI";
 script_family(english:family["english"], francais:family["francais"],
 		portugues:family["portugues"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "test-cgi";
if(is_cgi_installed(cgi))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 soc = open_sock_tcp(port);
 security_warning(port);
}
